% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeSimulator.R
\name{simulate_tree}
\alias{simulate_tree}
\title{Simulates a phylogeny using a beackward-in-time process using sampling dates and a trajectory}
\usage{
simulate_tree(
  simuResults,
  dates,
  deme,
  sampled,
  root,
  isFullTrajectory = FALSE,
  nTrials = 1,
  addInfos = FALSE,
  resampling = FALSE,
  verbose= FALSE
)
}
\arguments{
\item{simuResults}{Object of class \code{simutraj} resulting from running a simulator of trajectories built using the \code{build_simulator} function.}

\item{dates}{Contains the sampling dates. Can be a vector (for example using \code{seq} function), can be a named list or a file with header.}

\item{deme}{Vector containing the compartment names that contribute directly or indirectly to the phylogeny.}

\item{sampled}{A named vector with the proportions of sampling for each compartment. This is used in case there are multiple deme compartments where the sampling dates will be randomly associated to a compartment to sample. Sum of \code{sampled} must be 1.}

\item{root}{Name of the compartment from which the phylogeny is rooted.}

\item{isFullTrajectory}{logical: whether to simulate complete phylogeny where all death events generate leaves. By default, \code{isFullTrajectory=FALSE}.}

\item{addInfos}{logical: whether to define each internal node's name by the reaction. By default, \code{addInfos=FALSE}.}

\item{resampling}{logical: whether to allow a sampled individual to transmit the pathogen once again. By default, \code{resampling=FALSE}.}

\item{nTrials}{Number of trials of simulations if the simulation fails, meaning that the simulation ends before the final time asked as input. By default, \code{nTrials=1}.}

\item{verbose}{logical: whether to print some information}
}
\value{
An object of class \code{ape::phylo}.
}
\description{
Simulates a phylogeny using a beackward-in-time process using sampling dates and a trajectory
}
\author{
Gonche Danesh
}
