% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{univariate_pairwise}
\alias{univariate_pairwise}
\title{post hoc univariate analysis to MANOVA}
\usage{
univariate_pairwise(x, out, padjust, digits, lower.tail, ...)
}
\arguments{
\item{x}{A data frame containing summary statistics.}

\item{out}{output of multivariate function}

\item{padjust}{Method of p.value adjustment for multiple comparisons
following \link[stats]{p.adjust}  Default: "none".}

\item{digits}{Number of significant digits, Default: 4}

\item{lower.tail}{Logical; if TRUE probabilities are `P[X <= x]`,
otherwise, `P[X > x]`., Default: FALSE}

\item{...}{
  Arguments passed on to \code{\link[=multivariate]{multivariate}}
  \describe{
    \item{\code{R.res}}{Pooled within correlational matrix, Default: NULL}
    \item{\code{Trait}}{Number of the column containing names of measured parameters,
Default: 1}
    \item{\code{Pop}}{Number of the column containing populations' names, Default: 2}
    \item{\code{type_manova}}{type of MANOVA test "I","II" or "III", Default:"II".}
    \item{\code{manova_test_statistic}}{type of test statistic used either "W" for "Wilks","P"
for "Pillai", "HL" for "Hotelling-Lawley" or "R" for "Roy's largest root",
Default: "W".}
    \item{\code{interact_manova}}{Logical; if TRUE calculates MANOVA for the interaction
effects,Default: TRUE.}
    \item{\code{es_manova}}{effect size either ,"eta" for eta squared, or "none"for
not reporting an effect size, Default:"none".}
    \item{\code{univariate}}{Logical; if TRUE conducts multiple univariate analyses on
different parameters separately, Default: FALSE}
    \item{\code{CI}}{confidence interval coverage takes value from 0 to 1, Default: 0.95.}
  }}
}
\description{
post hoc univariate analysis to MANOVA
}
\keyword{internal}
