% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tg.R
\name{Tg}
\alias{Tg}
\title{Greene t-test of Sexual Dimorphism}
\usage{
Tg(
  x = NULL,
  Pop = 1,
  es = FALSE,
  plot = FALSE,
  ...,
  alternative = "two.sided",
  padjust = "none",
  letters = FALSE,
  digits = 4,
  sig.level = 0.05,
  N = NULL,
  m = NULL,
  m2 = NULL,
  f = NULL,
  f2 = NULL,
  M.mu = NULL,
  M.mu2 = NULL,
  F.mu = NULL,
  F.mu2 = NULL,
  M.sdev = NULL,
  M.sdev2 = NULL,
  F.sdev = NULL,
  F.sdev2 = NULL
)
}
\arguments{
\item{x}{Tibble/data frame containing summary statistics, Default: NULL}

\item{Pop}{Number of the column containing populations' names, Default: 1}

\item{es}{Logical; if TRUE effect size is included in the output , Default:
FALSE}

\item{plot}{Logical; if TRUE graphical matrix of p-values, Default: TRUE}

\item{...}{additional arguments that can be passed to
\link[corrplot:corrplot]{corrplot} function.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "two.sided", "greater" or "less", Default: 'two.sided'}

\item{padjust}{Method of p.value adjustment for multiple comparisons following
\link{p.adjust.methods}, Default: 'none'}

\item{letters}{Logical; if TRUE returns letters for pairwise comparisons where
significantly different populations are given different letters, Default:
FALSE'}

\item{digits}{Number of significant digits, Default: 4}

\item{sig.level}{Critical p.value, Default: 0.05}

\item{N}{Number of pairwise comparisons for \link{p.adjust.methods}, if left \code{NULL}
it will follow the formula \code{n(n-1)/2} where \code{n} is the number of populations
, Default: NULL}

\item{m}{Number of male sample size in the first population, Default: NULL}

\item{m2}{Number of male sample size in the second population, Default: NULL}

\item{f}{Number of female sample size in the first population, Default: NULL}

\item{f2}{Number of female sample size in the second population, Default: NULL}

\item{M.mu}{Means for males in the first population, Default: NULL}

\item{M.mu2}{Means for males in the second population, Default: NULL}

\item{F.mu}{Means for females in the first population, Default: NULL}

\item{F.mu2}{Means for females in the second population, Default: NULL}

\item{M.sdev}{Standard deviation for males in the first population, Default:
NULL}

\item{M.sdev2}{Standard deviation for males in the second population, Default:
NULL}

\item{F.sdev}{Standard deviation for females in the first population, Default:
NULL}

\item{F.sdev2}{Standard deviation for females in the second population,
Default: NULL}
}
\value{
Tibble of t.test results
}
\description{
Calculation and visualization of the differences in degree sexual
dimorphism between two populations using summary statistics as input.
}
\details{
Summary statistics can be entered directly as arguments in case of
comparing two populations or as a tibble/data frame of summary statistics
where the column containing population names is chosen by position (first by
default), other columns of summary data should have specific names (case
sensitive) similar to \link{baboon.parms_df}
}
\examples{
#Comparisons of femur head diameter in four populations
library(TestDimorph)
m <- c(150.00, 82.00, 36.00, 34.00)
f <- c(150.00, 58.00, 34.00, 24.00)
M.mu <- c(49.39, 48.33, 46.99, 45.20)
F.mu <- c(42.91, 42.89, 42.44, 40.90)
M.sdev <- c(3.01, 2.53, 2.47, 2.00)
F.sdev <- c(2.90, 2.84, 2.26, 2.90)
df <- cbind.data.frame(
  Pop = c('Turkish', 'Bulgarian', 'Greek', 'Portuguese '),
  m,
  f,
  M.mu,
  F.mu,
  M.sdev,
  F.sdev,
  stringsAsFactors = TRUE
)
Tg(
   df,
   plot = TRUE,
   method = 'ellipse',
  type = 'lower',
   col = c(
       '#AEB6E5',
       '#B1A0DB',
       '#B788CD',
       '#BC6EB9',
       '#BC569E',
       '#B6407D',
       '#A93154'
   ),
   tl.cex = 0.8,
   tl.col = 'black',
  insig =
       'label_sig',
   tl.srt = 0.1,
   pch.cex = 2.5,
   tl.pos = 'ld',
   win.asp = 1,
   number.cex = 0.5,
   na.label = 'NA'
)
}
\references{
\insertRef{greene1989comparison}{TestDimorph}
\insertRef{timonov2014study}{TestDimorph}
\insertRef{gulhan2015new}{TestDimorph}
}
\seealso{
\code{\link[multcompView]{multcompLetters}}
\code{\link[corrplot]{corrplot}}
}
