% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{polygonDrawOptions}
\alias{polygonDrawOptions}
\title{Options for Drawing Polygons on the Map}
\usage{
polygonDrawOptions(stroke = TRUE, weight = 5, color = c("red",
  "orange", "green"), opacity = 0.5, fill = TRUE, fillColor = color,
  fillOpacity = 0.2, dashArray = NULL, smoothFactor = 1,
  noClip = FALSE)
}
\arguments{
\item{stroke}{Whether to draw the polygon borders.}

\item{weight}{Stroke width in pixels.}

\item{color}{Stroke colour.}

\item{opacity}{Stroke opacity.}

\item{fill}{Whether to fill the polygons in with colour.}

\item{fillColor}{The fill colour.}

\item{fillOpacity}{The fill opacity.}

\item{dashArray}{A string to define the stroke dash pattern.}

\item{smoothFactor}{How much to simplify polylines on each zoom level.}

\item{noClip}{Whether to disable polyline clipping.}
}
\value{
A list of options governing how the polygons appear on the map
}
\description{
Function to return a list of the desired drawing options - you can set all the usual
parameters of a call to \code{\link[leaflet]{addPolygons}}.
}
\examples{
# show the list
polygonDrawOptions()

}
