% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableHC.R
\name{HC.vals}
\alias{HC.vals}
\title{Higher Criticism Statistics}
\usage{
HC.vals(pv, alpha = 0.45, stbl = TRUE)
}
\arguments{
\item{pv}{A list of numbers betwee 0 and 1.}

\item{alpha}{A number between 0 and 1.}

\item{stbl}{A boolean.}
}
\value{
A list containing the following fields:
 \code{HC} -- Higher Critcism (HC) score 
 \code{HC.star} -- HC score corrected to finite sample
 \code{p} -- p-value attaining \code{HC}
 \code{p.star} -- p-value attaining \code{HC.star}
}
\description{
Compute HC stasitic and p-value attaining it from a list of P-values.
Can be used with function \code{\link{tables.pval}} to 
get a list of p-values discriminating each feature
between the two tables. 

\code{stbl} -- normalize using expeted p-value 
(stbl==True) or observed (stbl==False)
\code{alpha} -- lower fraction of p-values to use
}
\examples{
tb1 = table(c(1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,5,6,6,7,7,7))
tb2 = table(c(1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,4,4,4,5,5,5,6))
PV = tables.pval(tb1, tb2) # compute P-values 
HC.vals(PV$pv)  # combine P-values using the HC statistics


text1 = "But our fish said, No ! No ! Make that cat go away ! 
           Tell that Cat in the Hat You do NOT want to play . 
           He should not be here . He should not be about . 
         He should not be here When your mother is out !"
text2 = "Now ! Now ! Have no fear . Have no fear! said the cat . 
           My tricks are not bad , Said the Cat in the Hat . Why , 
            we can have Lots of good fun, if you wish, with a game
             that I call UP - UP - UP with a fish !"

tb1 = table(strsplit(tolower(text1),' '))
tb2 = table(strsplit(tolower(text2),' '))
pv = tables.pval(tb1,tb2)
HC.vals(pv$pv)

}
