% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_functions.R
\name{two_fold_convolution_kernel}
\alias{two_fold_convolution_kernel}
\title{Two-Fold Convolution Kernel Function}
\usage{
two_fold_convolution_kernel(u, kernel_func)
}
\arguments{
\item{u}{A numeric vector of points at which the two-fold convolution kernel is evaluated.}

\item{kernel_func}{A function representing the kernel to be convolved.}
}
\value{
A numeric vector of two-fold convolution kernel values corresponding to each input \code{u}.
}
\description{
This function computes the two-fold convolution of a given kernel function with itself.
The convolution is evaluated over a range of inputs \eqn{u} and is set to zero outside
the interval \([-2, 2]\).
}
\details{
The two-fold convolution kernel is defined as:
\deqn{
K^{(2)}(u) = \int_{-1}^{1} K(v) \cdot K(u - v) \, dv
}
where \eqn{K} is the original kernel function. The function evaluates this convolution for each
input \code{u} within the interval \([-2, 2]\) and sets it to zero outside this range.
}
\keyword{internal}
