% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSplot.R
\name{TSplot}
\alias{TSplot}
\title{'TSplot'}
\usage{
TSplot(origin_t, ARIMAmodel, XREG = NULL, NEWtitle = "Result",
  Ylab = "Value", Xlab = "Time(Month/Year)",
  ts_original = "original time series",
  ts_forecast = "forecasted time series", title_size = 10)
}
\arguments{
\item{origin_t}{Number of periods of original time series data you wish to include in the plot
write all if all periods should be included}

\item{ARIMAmodel}{ARIMA model created by function \code{auto.arima()}}

\item{XREG}{if using ARIMAX model, put in the regularized X matrix}

\item{NEWtitle}{title for this plot}

\item{Ylab}{label of Y axis}

\item{Xlab}{label of X axis}

\item{ts_original}{label for original time series line}

\item{ts_forecast}{label for forecasted time series line}

\item{title_size}{size of the title}
}
\value{
a plot result created by plot_ly() function
}
\description{
Plotly method working on time series analysis. Work only for month & year dataset(i.e. dataset that can
satisfy the format required by function \code{as.yearmon} from package \code{zoo})
}
\details{
The function \code{TSplot} is based on package \code{plotly}. It applies \code{plot_ly} function to create
interactive plot for time-series analysis result. It requires a fitted model by function \code{auto.arima}.
If you are fitting an ARIMA model with external regressors (i.e. \code{Xreg}), then you must put inside the
external regressors again.
}
\examples{
require(forecast)
require(zoo)
require(plotly)

# Creating time series data
MCSI_Data_monthAvg_ts_Y <- ts(Y, start=c(1978,1), end=c(2018, 12), frequency = 12)

# Applying ARIMAX model
modArima <- auto.arima(MCSI_Data_monthAvg_ts_Y, xreg=X)

# Creating plot_ly results
## 48 means that there will be 48 periods from the original
## time series dataset that is included in the plot result.
## You could also change this to "all" to see all original dataset in a single plot.
\donttest{TSplot(48,modArima,X_new,title_size = 8,ts_original = "Original time series",
ts_forecast = "Predicted time series")}

}
\author{
SOCR team <\url{http://socr.umich.edu/people/}>
}
