% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TSMining.R
\name{Func.visual.SingleMotif}
\alias{Func.visual.SingleMotif}
\title{A function to prepare the dataset for visualizing the univaraite motifs discovered}
\usage{
Func.visual.SingleMotif(single.ts, window.size, motif.indices)
}
\arguments{
\item{single.ts}{is a numeric vector used to represent the univariate time series}

\item{window.size}{is the window size used to create subsequences. It is also the length of univariate motifs}

\item{motif.indices}{is the results of Func.motif()$Indices, which store the starting position of subsequences for each univaraite motifs}
}
\value{
The function returns a list of three elements. The first element is data.1, which can be used to show the whole time series with motifs identifed highlighted. The second element is data.2, which can be used to visualize the members of each motif. It is a list containing data frames. Each data frame is designed to visualize the members in each motif.
}
\description{
This function create a data set for the use of visualizing the univariate motifs discovered
}
\examples{
data(test)
#Perform univariate motif discovery for the first dimension data in the example data
res.1 <- Func.motif(ts = test$TS1, global.norm = TRUE, local.norm = FALSE,
window.size = 10, overlap = 0, w = 5, a = 3, mask.size = 3, eps = .01)
data.vis <- Func.visual.SingleMotif(single.ts=test$TS1, window.size=10, motif.indices=res.1$Indices)
#To visualize general information of motifs discovered on the whole time series
library(ggplot2)
ggplot(data = data.vis$data.1) +
 geom_line(aes(x = 1:dim(data.vis$data.1)[1], y = X)) +
 geom_point(aes(x = 1:dim(data.vis$data.1)[1], y = X, color=Y))
#To visualize the detailed information of the 1st motif
ggplot(data = data.vis$data.2[[1]]) + geom_line(aes(x = Time, y = Value, linetype=Instance))
}

