% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdm_hw.cor.R
\name{tdm_hw.cor}
\alias{tdm_hw.cor}
\title{Heartwood correction}
\usage{
tdm_hw.cor (input, dt.max, probe.length = 20,
            sapwood.thickness = 18, df = FALSE)
}
\arguments{
\item{input}{A \code{\link{tdm_dt.max}} ouput or \code{\link{is.trex}}-compliant object of \eqn{\Delta T } (or \eqn{\Delta V}) values containing
a timestamp and a value column.}

\item{dt.max}{Optional \code{zoo} object or \code{data.frame} (columns = “timestamp” or “value”)
containing the \eqn{\Delta T_{max}}{\Delta Tmax} when no \code{\link{is.trex}}-compliant object is provided.}

\item{probe.length}{Numeric, the length of the TDM probes in mm.}

\item{sapwood.thickness}{Numeric, the sapwood thickness in mm.}

\item{df}{Logical; If \code{TRUE}, output is provided in a \code{data.frame} format
with a timestamp and a value column. If \code{FALSE}, output
is provided as a \code{zoo} vector object (default = \code{FALSE}).}
}
\value{
A \code{zoo} object or \code{data.frame} in the appropriate
format for other functionalities. See \code{\link{tdm_dt.max}} for output specifications.
All \eqn{K} values for each method are provided when an output
from \code{\link{tdm_dt.max}} was provided.
If individual time series are provided for \code{input} and \code{tdm_dt.max} an alternative output is provided:

\describe{

 \item{input}{= \eqn{\Delta T} input data.}
 \item{dt.max}{ \eqn{\Delta T_{max}{\Delta Tmax}} input data.}
 \item{dtsw}{Corrected \eqn{\Delta T} data.}
 \item{k.value}{\eqn{K} values calculated according to Clearwater et al. (1999).}
 \item{settings}{data.frame of the applied \code{probe.length} and \code{sapwood.thickness}}

}
}
\description{
The function corrects for the proportion of the probe that is installed
within the non-conductive heartwood according to Clearwater \emph{et al.} (1999).
The function requires \eqn{\Delta T_{max}}{\Delta Tmax}, the probe length and the
sapwood thickness. The correction is applied on the \eqn{\Delta T} (or \eqn{\Delta V}) values and \eqn{K}
is recalculated accordingly. When an \code{\link{is.trex}}-compliant object is
provided, the \eqn{K} values for each method are determined (see \code{\link{tdm_dt.max}}.
}
\details{
The function applied the correction provided by Clearwater \emph{et al.} 1999.
 \eqn{\Delta T} (or \eqn{\Delta V}) was corrected (denoted as \eqn{\Delta T_{sw}}{\Delta Tsw}) for the proportion of
 the probe that was inserted into the conducting sapwood vs the
 proportion of the probe that was inserted into the nonconductive heartwood
 (\eqn{\gamma} in mm mm-1). Together with \eqn{\Delta T_{max}}{\Delta Tmax}, \eqn{\Delta T} was corrected
 according to the following equation:
 \deqn{\Delta T_{sw} = (\Delta T~-~(1~–~\gamma) *  \Delta T_{max}) / \gamma}{\Delta Tsw = (\Delta T – (1 – \gamma)  \Delta Tmax) / \gamma}

 \eqn{\Delta T_{sw}}{\Delta Tsw} together with \eqn{\Delta T_{max}}{\Delta Tmax} is then recalculated to \eqn{K}.
}
\examples{
\donttest{
#correct for probes being inserted into the heartwood
raw   <-is.trex(example.data(type="doy"),
          tz="GMT",time.format="\%H:\%M",solar.time=TRUE,
          long.deg=7.7459,ref.add=FALSE)
input <- dt.steps(input=raw,
                   start="2014-05-08 00:00",
                   end="2014-07-25 00:50",
                  time.int=15,max.gap=60,decimals=6,df=F)
input[which(input<0.2)]<-NA
input <-tdm_dt.max(input, methods=c("pd","mw","dr"),
                 det.pd=TRUE,interpolate=FALSE,max.days=10,df=FALSE)
output.data<-tdm_hw.cor(input,probe.length=20,
                   sapwood.thickness=18,df=FALSE)
plot(output.data$k.dr,col="orange")
lines(input$k.dr)
}

}
\references{
Clearwater MJ, Meinzer FC, Andrade JL, Goldstein G, Holbrook NM. 1999.
Potential errors in measurement of nonuniform sap flow using heat dissipation probes.
Tree Physiology 19:681–687 \doi{10.1093/treephys/19.10.681}
}
