% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_compare_cor.R
\name{boot_compare_cor}
\alias{boot_compare_cor}
\title{Comparing Correlations between independent studies with Bootstrapping}
\usage{
boot_compare_cor(
  x1,
  y1,
  x2,
  y2,
  alternative = c("two.sided", "less", "greater", "equivalence", "minimal.effect"),
  method = c("pearson", "kendall", "spearman", "winsorized", "bendpercent"),
  alpha = 0.05,
  null = 0,
  R = 1999,
  ...
)
}
\arguments{
\item{x1, y1}{numeric vectors of data values. x and y must have the same length from study 1.}

\item{x2, y2}{numeric vectors of data values. x and y must have the same length from study 2.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater", "less", "equivalence" (TOST), or "minimal.effect" (TOST). You can specify just the initial letter.}

\item{method}{a character string indicating which correlation coefficient is to be used for the test. One of "winsorized", "bendpercent","pearson", "kendall", or "spearman", can be abbreviated.}

\item{alpha}{alpha level (default = 0.05)}

\item{null}{a number indicating the null hypothesis. Default is a correlation of zero.}

\item{R}{number of bootstrap replicates}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
A list with class "htest" containing the following components:
\describe{
  \item{\code{"p.value"}}{numeric scalar containing the p-value for the test under the null hypothesis.}
  \item{\code{"estimate"}}{difference in correlations between studies.}
  \item{\code{"conf.int"}}{percentile (bootstrap) confidence interval for difference in correlations.}
  \item{\code{"null.value"}}{the specified hypothesized value for the null hypothesis.}
  \item{\code{"alternative"}}{character string indicating the alternative hypothesis (the value of the input argument alternative). Possible values are "greater", "less", or "two-sided".}
  \item{\code{"method"}}{a character string indicating how the association was measured.}
  \item{\code{"data.name"}}{Names of input values..}
  \item{\code{"boot_res"}}{List of bootstrapped results.}
  \item{\code{"call"}}{the matched call.}
}
}
\description{
A function to compare standardized mean differences (SMDs) between studies. This function is intended to be used to compare the compatibility of original studies with replication studies (lower p-values indicating lower compatibility)
}
