
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
dataTOSTrOptions <- R6::R6Class(
    "dataTOSTrOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            pairs = NULL,
            low_eqbound_r = -0.3,
            high_eqbound_r = 0.3,
            alpha = 0.05,
            desc = FALSE,
            plots = FALSE, ...) {

            super$initialize(
                package='TOSTER',
                name='dataTOSTr',
                requiresData=TRUE,
                ...)
        
            private$..pairs <- jmvcore::OptionPairs$new(
                "pairs",
                pairs,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"))
            private$..low_eqbound_r <- jmvcore::OptionNumber$new(
                "low_eqbound_r",
                low_eqbound_r,
                default=-0.3)
            private$..high_eqbound_r <- jmvcore::OptionNumber$new(
                "high_eqbound_r",
                high_eqbound_r,
                default=0.3)
            private$..alpha <- jmvcore::OptionNumber$new(
                "alpha",
                alpha,
                min=0,
                max=1,
                default=0.05)
            private$..desc <- jmvcore::OptionBool$new(
                "desc",
                desc,
                default=FALSE)
            private$..plots <- jmvcore::OptionBool$new(
                "plots",
                plots,
                default=FALSE)
        
            self$.addOption(private$..pairs)
            self$.addOption(private$..low_eqbound_r)
            self$.addOption(private$..high_eqbound_r)
            self$.addOption(private$..alpha)
            self$.addOption(private$..desc)
            self$.addOption(private$..plots)
        }),
    active = list(
        pairs = function() private$..pairs$value,
        low_eqbound_r = function() private$..low_eqbound_r$value,
        high_eqbound_r = function() private$..high_eqbound_r$value,
        alpha = function() private$..alpha$value,
        desc = function() private$..desc$value,
        plots = function() private$..plots$value),
    private = list(
        ..pairs = NA,
        ..low_eqbound_r = NA,
        ..high_eqbound_r = NA,
        ..alpha = NA,
        ..desc = NA,
        ..plots = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
dataTOSTrResults <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        tost = function() private$..tost,
        eqb = function() private$..eqb,
        desc = function() private$..desc,
        plots = function() private$..plots),
    private = list(
        ..tost = NA,
        ..eqb = NA,
        ..desc = NA,
        ..plots = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="TOST Correlation")
            private$..tost <- jmvcore::Table$new(
                options=options,
                name="tost",
                title="TOST Results",
                rows="(pairs)",
                clearWith=list(
                    "alpha",
                    "low_eqbound_r",
                    "high_eqbound_r"),
                columns=list(
                    list(`name`="i1", `title`="", `type`="text", `content`="($key)"),
                    list(`name`="i2", `title`="", `type`="text", `content`="($key)"),
                    list(`name`="b[0]", `title`="", `type`="text", `content`="Pearson's r"),
                    list(`name`="r[0]", `title`="r", `type`="number"),
                    list(`name`="p[0]", `title`="p", `type`="number", `format`="zto,pvalue"),
                    list(`name`="b[1]", `title`="", `type`="text", `content`="TOST Upper"),
                    list(`name`="r[1]", `title`="r", `type`="number"),
                    list(`name`="p[1]", `title`="p", `type`="number", `format`="zto,pvalue"),
                    list(`name`="b[2]", `title`="", `type`="text", `content`="TOST Lower"),
                    list(`name`="r[2]", `title`="r", `type`="number"),
                    list(`name`="p[2]", `title`="p", `type`="number", `format`="zto,pvalue")))
            private$..eqb <- jmvcore::Table$new(
                options=options,
                name="eqb",
                title="Equivalence Bounds",
                rows="(pairs)",
                clearWith=list(
                    "alpha",
                    "low_eqbound_r",
                    "high_eqbound_r"),
                columns=list(
                    list(`name`="i1", `title`="", `type`="text", `content`="($key)"),
                    list(`name`="i2", `title`="", `type`="text", `content`="($key)"),
                    list(`name`="low", `title`="Low", `type`="number"),
                    list(`name`="high", `title`="High", `type`="number"),
                    list(`name`="cil", `title`="Lower", `superTitle`="Confidence interval"),
                    list(`name`="ciu", `title`="Upper", `superTitle`="Confidence interval")))
            private$..desc <- jmvcore::Table$new(
                options=options,
                name="desc",
                title="Descriptives",
                visible="(desc)",
                rows="(pairs)",
                clearWith=NULL,
                columns=list(
                    list(`name`="name[1]", `title`="", `type`="text"),
                    list(`name`="n[1]", `title`="N", `type`="integer"),
                    list(`name`="m[1]", `title`="Mean", `type`="number"),
                    list(`name`="med[1]", `title`="Median", `type`="number"),
                    list(`name`="sd[1]", `title`="SD", `type`="number"),
                    list(`name`="se[1]", `title`="SE", `type`="number"),
                    list(`name`="name[2]", `title`="", `type`="text"),
                    list(`name`="n[2]", `title`="N", `type`="integer"),
                    list(`name`="m[2]", `title`="Mean", `type`="number"),
                    list(`name`="med[2]", `title`="Median", `type`="number"),
                    list(`name`="sd[2]", `title`="SD", `type`="number"),
                    list(`name`="se[2]", `title`="SE", `type`="number")))
            private$..plots <- jmvcore::Array$new(
                options=options,
                name="plots",
                title="Plots",
                items="(pairs)",
                visible="(plots)",
                template=jmvcore::Image$new(
                    options=options,
                    title="$key",
                    renderFun=".plot",
                    width=180,
                    clearWith=list(
                        "alpha",
                        "low_eqbound_r",
                        "high_eqbound_r")))
            self$add(private$..tost)
            self$add(private$..eqb)
            self$add(private$..desc)
            self$add(private$..plots)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
dataTOSTrBase <- R6::R6Class(
    "dataTOSTrBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'TOSTER',
                name = 'dataTOSTr',
                version = c(1,0,0),
                options = options,
                results = dataTOSTrResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL)
        }))

#' TOST Correlation
#'
#' 
#' @param data the data as a data frame
#' @param pairs a list of vectors of strings naming variables to correlate 
#'   from \code{data} 
#' @param low_eqbound_r lower equivalence bounds (e.g., -0.3) expressed in a 
#'   correlation effect size 
#' @param high_eqbound_r upper equivalence bounds (e.g., 0.3) expressed in a 
#'   correlation effect size 
#' @param alpha alpha level (default = 0.05)
#' @param desc \code{TRUE} or \code{FALSE} (default), provide descriptive 
#'   statistics 
#' @param plots \code{TRUE} or \code{FALSE} (default), provide plots 
#' @export
dataTOSTr <- function(
    data,
    pairs,
    low_eqbound_r = -0.3,
    high_eqbound_r = 0.3,
    alpha = 0.05,
    desc = FALSE,
    plots = FALSE) {

    options <- dataTOSTrOptions$new(
        pairs = pairs,
        low_eqbound_r = low_eqbound_r,
        high_eqbound_r = high_eqbound_r,
        alpha = alpha,
        desc = desc,
        plots = plots)

    results <- dataTOSTrResults$new(
        options = options)

    analysis <- dataTOSTrClass$new(
        options = options,
        data = data)

    analysis$run()
    analysis$render()

    analysis$results
}
