% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HAR.TLineSeg.R
\name{HAR.TLineSeg}
\alias{HAR.TLineSeg}
\title{Uniformly sample from a max-plus tropical line segment}
\usage{
HAR.TLineSeg(D1, D2)
}
\arguments{
\item{D1}{point in the tropical projective torus}

\item{D2}{point in the tropical projective torus}
}
\value{
point on the line segment defined by D1 and D2
}
\description{
This function uses a hit-and-run sampler to uniformly sample from a max-plus tropical line segment
}
\examples{
D1 <-c(0,4,2)
D2 <- c(0,7,-1)
HAR.TLineSeg(D1, D2)
}
\references{
Yoshida, Ruriko, Keiji Miura and David Barnhill (2022). Hit and Run Sampling from Tropically Convex Sets.
}
\author{
Ruriko Yoshida \email{ryoshida@nps.edu}
}
