% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.tfisher.omni.R
\name{p.tfisher.omni}
\alias{p.tfisher.omni}
\title{CDF of omnibus thresholding Fisher's p-value combination statistic under the null hypothesis.}
\usage{
p.tfisher.omni(q, n, TAU1, TAU2)
}
\arguments{
\item{q}{- quantile, could be a vector.}

\item{n}{- dimension parameter, i.e. the number of p-values to be combined.}

\item{TAU1}{- a vector of truncation parameters. Must be in non-descending order.}

\item{TAU2}{- a vector of normalization parameters. Must be in non-descending order.}
}
\value{
The left-tail probability of the null distribution of omnibus thresholding Fisher's p-value combination statistic.
}
\description{
CDF of omnibus thresholding Fisher's p-value combination statistic under the null hypothesis.
}
\examples{
q = 0.05
n = 20
TAU1 = c(0.01, 0.05, 0.5, 1)
TAU2 = c(0.1, 0.2, 0.5, 1)
p.tfisher.omni(q=q, n=n, TAU1=TAU1, TAU2=TAU2)
}
\references{
1. Hong Zhang and Zheyang Wu. "Optimal Thresholding of Fisher's P-value Combination
Tests for Signal Detection", submitted.
}
\seealso{
\code{\link{stat.tfisher.omni}} for the definition of the statistic.
}
