% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tdmClassifyLoop.r
\name{tdmClassifyLoop}
\alias{TDMclassifier}
\alias{tdmClassifyLoop}
\title{Core classification double loop of TDMR returning a \code{\link{TDMclassifier}} object.}
\usage{
tdmClassifyLoop(dset, response.variables, input.variables, opts, tset = NULL)
}
\arguments{
\item{dset}{the data frame containing training and validation data.}

\item{response.variables}{name of column which carries the target variable - or -
                vector of names specifying multiple target columns
                (these columns are not used during prediction, only for evaluation)}

\item{input.variables}{vector with names of input columns}

\item{opts}{a list from which we need here the following entries
    \describe{
      \item{\code{NRUN}}{ number of runs (outer loop)}
      \item{\code{TST.SEED}}{ =NULL: get a new random number seed with \code{\link{tdmRandomSeed}}. =any value: set the random number seed
              to this value to get reproducible random numbers and thus reproducible training-test-set-selection.
              (only relevant in case TST.kind=="cv" or "rand") (see also MOD.SEED in \code{\link{tdmClassify}})}
      \item{\code{TST.kind}}{ how to create cvi, handed over to \code{\link{tdmModCreateCVindex}}. If TST.kind="col", then cvi is taken from dset[,opts$TST.col].}
      \item{\code{GD.RESTART}}{ [TRUE] =TRUE/FALSE: do/don't restart graphic devices}
      \item{\code{GD.DEVICE}}{ ["non"|"win"|"pdf"|"png"]}
    }}

\item{tset}{[NULL] If not NULL, this is the validation data set. If NULL, the validation data
               set is build from \code{dset} according to the procedure prescribed in \code{opts$TST.*}.}
}
\value{
\code{result},  an object of class \code{\link{TDMclassifier}}, this is a list with results, containing
      \item{lastRes}{ last run, last fold: result from \code{\link{tdmClassify}}}
      \item{C_train}{ classification error on training set}
      \item{G_train}{ gain on training set}
      \item{R_train}{ relative gain on training set (percentage of max. gain on this set)}
      \item{*_vali}{ --- similar, with vali set instead of training set ---   }
      \item{*_vali2}{ --- similar, with vali2 set instead of training set ---  }
      \item{Err}{ a data frame with as many rows as opts$NRUN and 9 columns corresponding to
				the nine variables described above }
      \item{predictions}{ last run: data frame with dimensions [nrow(dset),length(response.variable)]. In case of CV, all
             CV predictions (for each record in dset), in other cases mixed validation / train set predictions.  }
      \item{predProbList}{ the ith element in this list has data on the prediction probabilities of the ith run. See info on
             \code{predProb} in \code{\link{tdmClassify}}. }

   Each performance measure \code{C_*, G_*, R_*} is a vector of length \code{opts$NRUN}. To be specific, \code{C_train[i]} is the
   classification error on the training set from the \code{i}-th run. This error is \code{mean(res$allEVAL$cerr.trn)}, i.e. the
   mean of the classification errors from all response variables when \code{res} is the return value of  \code{\link{tdmClassify}}.
   In the case of cross validation, for each performance measure an additional averaging over all folds is done.
}
\description{
tdmClassifyLoop contains a double loop (opts$NRUN and CV-folds)
   and calls \code{\link{tdmClassify}}. It is called  by all classification R-functions main_*. \cr
   It returns an object of class \code{\link{TDMclassifier}}.
}
\examples{
#*# --------- demo/demo00-0classif.r ---------
#*# This demo shows a simple data mining process (phase 1 of TDMR) for classification on
#*# dataset iris.
#*# The data mining process in tdmClassifyLoop calls randomForest as the prediction model.
#*# It is called opts$NRUN=2 times with different random train-validation set splits.
#*# Therefore data frame result$Err has two rows
#*#
opts=tdmOptsDefaultsSet()                       # set all defaults for data mining process
gdObj <- tdmGraAndLogInitialize(opts);          # init graphics and log file

data(iris)
response.variables="Species"                    # names, not data (!)
input.variables=setdiff(names(iris),"Species")

result = tdmClassifyLoop(iris,response.variables,input.variables,opts)

print(result$Err)
}
\author{
Wolfgang Konen (\email{wolfgang.konen@fh-koeln.de}), FHK, Sep'2010 - Jun'2012
}
\seealso{
\code{\link{print.TDMclassifier}}, \code{\link{tdmClassify}}, \code{\link{tdmRegress}}, \code{\link{tdmRegressLoop}}
}

