% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swim_Parse.R
\name{Swim_Parse}
\alias{Swim_Parse}
\alias{swim_parse}
\title{Formats swimming and diving data read in with Read_Results into dataframe}
\usage{
Swim_Parse(
  file,
  avoid = avoid_default,
  typo = typo_default,
  replacement = replacement_default
)

swim_parse(
  file,
  avoid = avoid_default,
  typo = typo_default,
  replacement = replacement_default
)
}
\arguments{
\item{file}{output from \code{Read_Results}}

\item{avoid}{a list of strings.  Rows in \code{x} containing these strings will not be included. For example "Pool:", often used to label pool records, could be passed to \code{avoid}.  The default is \code{avoid_default}, which contains many strings similar to "Pool:", such as "STATE:" and "Qual:".  Users can supply their own lists to \code{avoid}.}

\item{typo}{a list of strings that are typos in the original results.  \code{Swim_Parse} is particularly sensitive to accidental double spaces, so "Central  High School", with two spaces between "Central" and "High" is a problem, which can be fixed.  Pass "Central High School" to \code{typo}.  Unexpected commas as also an issue, for example "Texas, University of" should be fixed using \code{typo} and \code{replacement}}

\item{replacement}{a list of fixes for the strings in \code{typo}.  Here one could pass "Central High School" (one space between "Central" and "High") and "Texas" to \code{replacement} fix the issues described in \code{typo}}
}
\value{
returns a dataframe with columns \code{Name}, \code{Place}, \code{Grade}, \code{School}, \code{Prelims_Time}, \code{Finals_Time}, \code{Points}, & \code{Event}.  Note all swims will have a \code{Finals_Time}, even if that time was actually swam in the prelims (i.e. a swimmer did not qualify for finals).  This is so that final results for an event can be generated from just one column.
}
\description{
Takes the output of Read_Results and cleans it.
}
\examples{
\dontrun{
Swim_Parse(Read_Results("http://www.nyhsswim.com/Results/Boys/2008/NYS/Single.htm", node = "pre"),
 typo = c("-1NORTH ROCKL"), replacement = c("1-NORTH ROCKL"))
 }
\dontrun{
Swim_Parse(Read_Results("inst/extdata/Texas-Florida-Indiana.pdf"),
 typo =  c("Indiana  University", ", University of"), replacement = c("Indiana University", ""))
 }
}
\seealso{
\code{Swim_Parse} must be run on the output of \code{\link{Read_Results}}
}
\author{
Greg Pilgrim \email{gpilgrim2670@gmail.com}
}
