% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec_swim_parse.R
\name{swim_parse_old}
\alias{swim_parse_old}
\title{Formats swimming and diving data read with \code{read_results} into a data
frame}
\usage{
swim_parse_old(
  file,
  avoid = avoid_default,
  typo = typo_default,
  replacement = replacement_default,
  splits = FALSE,
  split_length = 50,
  relay_swimmers = FALSE
)
}
\arguments{
\item{file}{output from \code{read_results}}

\item{avoid}{a list of strings.  Rows in \code{file} containing these strings
will not be included. For example "Pool:", often used to label pool
records, could be passed to \code{avoid}.  The default is
\code{avoid_default}, which contains many strings similar to "Pool:", such
as "STATE:" and "Qual:".  Users can supply their own lists to \code{avoid}.}

\item{typo}{a list of strings that are typos in the original results.
\code{swim_parse_old} is particularly sensitive to accidental double
spaces, so "Central  High School", with two spaces between "Central" and
"High" is a problem, which can be fixed.  Pass "Central  High School" to
\code{typo}.  Unexpected commas as also an issue, for example "Texas,
University of" should be fixed using \code{typo} and \code{replacement}}

\item{replacement}{a list of fixes for the strings in \code{typo}.  Here one
could pass "Central High School" (one space between "Central" and "High")
and "Texas" to \code{replacement} fix the issues described in \code{typo}}

\item{splits}{either \code{TRUE} or the default, \code{FALSE} - should
\code{swim_parse_old} attempt to include splits.}

\item{split_length}{either \code{25} or the default, \code{50}, the length of
pool at which splits are recorded.  Not all results are internally
consistent on this issue - some have races with splits by 50 and other
races with splits by 25.}

\item{relay_swimmers}{either \code{TRUE} or the default, \code{FALSE} -
should relay swimmers be reported.  Relay swimmers are reported in separate
columns named \code{Relay_Swimmer_1} etc.}
}
\value{
returns a data frame with columns \code{Name}, \code{Place},
  \code{Age}, \code{Team}, \code{Prelims_Time}, \code{Finals_Time},
  \code{Points}, \code{Event} & \code{DQ}.  Note all swims will have a
  \code{Finals_Time}, even if that time was actually swam in the prelims
  (i.e. a swimmer did not qualify for finals).  This is so that final results
  for an event can be generated from just one column.
}
\description{
Takes the output of \code{read_results} and cleans it, yielding a data frame
of swimming (and diving) results.  Old version, retired in dev build on Dec
21, 2020 and release version 0.7.0
}
\examples{
\dontrun{
swim_parse_old(
 read_results("http://www.nyhsswim.com/Results/Boys/2008/NYS/Single.htm", node = "pre"),
  typo = c("-1NORTH ROCKL"), replacement = c("1-NORTH ROCKL"),
  splits = TRUE,
  relay_swimmers = TRUE)
 }
\dontrun{
swim_parse_old(read_results("inst/extdata/Texas-Florida-Indiana.pdf"),
 typo =  c("Indiana  University", ", University of"), replacement = c("Indiana University", ""),
 splits = TRUE,
 relay_swimmers = TRUE)
 }
}
\seealso{
\code{swim_parse_old} must be run on the output of
  \code{\link{read_results}}
}
