% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_threeway_between.R
\name{power_threeway_between}
\alias{power_threeway_between}
\title{Analytic power calculation for three-way between designs.}
\usage{
power_threeway_between(design_result, alpha_level = 0.05)
}
\arguments{
\item{design_result}{Output from the ANOVA_design function}

\item{alpha_level}{Alpha level used to determine statistical significance (default to 0.05)}
}
\value{
mu = means

sigma = standard deviation

n = sample size

alpha_level = alpha level

Cohen_f_A = Cohen's f for main effect A

Cohen_f_B = Cohen's f for main effect B

Cohen_f_C = Cohen's f for main effect C

Cohen_f_AB = Cohen's f for the A*B interaction

Cohen_f_AC = Cohen's f for the A*C interaction

Cohen_f_BC = Cohen's f for the B*C interaction

Cohen_f_ABC = Cohen's f for the A*B*C interaction

f_2_A = Cohen's f squared for main effect A

f_2_B = Cohen's f squared for main effect B

f_2_C = Cohen's f squared for main effect C

f_2_AB = Cohen's f squared for A*B interaction

f_2_AC = Cohen's f squared for A*C interaction

f_2_BC = Cohen's f squared for B*C interaction

f_2_ABC = Cohen's f squared for A*B*C interaction

lambda_A = lambda for main effect A

lambda_B = lambda for main effect B

lambda_C = lambda for main effect C

lambda_AB = lambda for A*B interaction

lambda_AC = lambda for A*C interaction

lambda_BC = lambda for B*C interaction

lambda_ABC = lambda for A*B*C interaction

critical_F_A = critical F-value for main effect A

critical_F_B = critical F-value for main effect B

critical_F_C = critical F-value for main effect C

critical_F_AB = critical F-value for A*B interaction

critical_F_AC = critical F-value for A*C interaction

critical_F_BC = critical F-value for B*C interaction

critical_F_ABC = critical F-value for A*B*C interaction

power_A = power for main effect A

power_B = power for main effect B

power_C = power for main effect C

power_AB = power for A*B interaction

power_AC = power for A*C interaction

power_BC = power for B*C interaction

power_ABC = power for A*B*C interaction

df_A = degrees of freedom for main effect A

df_B = degrees of freedom for main effect B

df_C = degrees of freedom for main effect C

df_AB = degrees of freedom for A*B interaction

df_AC = degrees of freedom for A*C interaction

df_BC = degrees of freedom for B*C interaction

df_ABC = degrees of freedom for A*B*C interaction

df_error = degrees of freedom for error term

eta_p_2_A = partial eta-squared for main effect A

eta_p_2_B = partial eta-squared for main effect B

eta_p_2_C = partial eta-squared for main effect C

eta_p_2_AB = partial eta-squared for A*B interaction

eta_p_2_AC = partial eta-squared for A*C interaction

eta_p_2_BC = partial eta-squared for B*C interaction

eta_p_2_ABC = partial eta-squared for A*B*C interaction

mean_mat = matrix of the means
}
\description{
Analytic power calculation for three-way between designs.
}
\section{References}{

to be added
}

\examples{
design_result <- ANOVA_design(design = "2b*2b*2b", n = 40,
      mu = c(1, 0, 1, 0, 0, 1, 1, 0), sd = 2,
      labelnames = c("condition", "cheerful", "sad",
      "voice", "human", "robot", "color", "green", "red"))
power_result <- power_threeway_between(design_result, alpha_level = 0.05)
}
