% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_get_params.R
\name{sc_get_metric_names}
\alias{sc_get_metric_names}
\title{Get StreamCat Metric Names}
\usage{
sc_get_metric_names(category = NULL, aoi = NULL, year = NULL, dataset = NULL)
}
\arguments{
\item{category}{Filter StreamCat metrics based on the metric category}

\item{aoi}{Filter StreamCat metrics based on the area of interest}

\item{year}{Filter StreamCat metrics based on a particular year or years}

\item{dataset}{Filter StreamCat metrics based on the dataset name}
}
\value{
A dataframe of merics and description that match filter criteria
}
\description{
Function to filter StreamCat metrics metrics by category, area of interest,
dataset or year. Use `sc_get_params(categories)` or `sc_get_params(datasets)`
to see all the valid category or dataset options
}
\examples{
\dontrun{
metrics <- sc_get_metric_names(category='Wildfire')
metrics <- sc_get_metric_names(category = c('Deposition','Climate'),
aoi=c('Cat','Ws'))
metrics <- sc_get_metric_names(aoi='Other',
dataset=c('Canal Density','Predicted Channel Widths Depths'))

}
}
\author{
Marc Weber
}
