% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submod_otr.R
\name{submod_otr}
\alias{submod_otr}
\title{Subgroup Identification: Optimal Treatment Regime (through ctree)}
\usage{
submod_otr(Y, A, X, Xtest, mu_train, alpha = 0.05,
  minbucket = floor(dim(X)[1] * 0.1), maxdepth = 4, thres = ">0",
  ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{Xtest}{Test set}

\item{mu_train}{Patient-level estimates (See PLE_models)}

\item{alpha}{Significance level for variable selection (default=0.05)}

\item{minbucket}{Minimum number of observations in a tree node.
Default = floor( dim(train)[1]*0.05  )}

\item{maxdepth}{Maximum depth of any node in the tree (default=4)}

\item{thres}{Threshold for PLE, ex: I(PLE>thres). Default is ">0". Direction can be
reversed and can include equality sign (ex: "<=")}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Trained ctree (optimal treatment regime) model.
 \itemize{
  \item mod - tree (OTR) model object
}
}
\description{
For continuous, binary, or survival outcomes, regress I(PLE>thres)~X with
weights=abs(PLE) in ctree. For example, PLE could refer to individual treatment effect,
E(Y|A=1,X)-E(Y|A=0, X)
}
\examples{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

\donttest{
## Estimate PLEs (through Ranger) ##
res.ple = ple_model(Y, A, X, Xtest=X, family="gaussian", ple="ple_ranger")

## Fit OTR Subgroup Model ##
res_otr = submod_otr(Y, A, X, Xtest=X, mu_train = res.ple$mu_train)
plot(res_otr$mod)
}

}
\references{
Zhao et al. (2012) Estimated individualized treatment rules using outcome 
weighted learning. Journal of the American Statistical Association, 107(409): 1106-1118.
}
