% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ple_train.R
\name{ple_train}
\alias{ple_train}
\title{Patient-level Estimates: Train Model}
\usage{
ple_train(Y, A, X, Xtest, family = "gaussian", ple, hyper = NULL, ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{Xtest}{Test set}

\item{family}{Outcome type ("gaussian", "binomial", "survival"). Default is "gaussian".}

\item{ple}{PLE (Patient-Level Estimate) function. Maps the observed data to PLEs.
(Y,A,X) ==> PLE(X).}

\item{hyper}{Hyper-parameters for the ple model (must be list). Default is NULL.}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Trained ple models and patient-level estimates for train/test sets. For
family="gaussian" or "binomial", output estimates of
(E(Y|X,A=1), E(Y|X,A=0), E(Y|X,A=1)-E(Y|X,A=0)). For survival, output estimates of
(HR(X,A=1), HR(X,A=0), HR(X, A=1)-HR(X, A=0)) or (RMST(X,A=1), RMST(X,A=0), 
RMST(X, A=1)-RMST(X, A=0)).

 \itemize{
  \item mod - trained model(s)
  \item mu_train - Patient-level estimates (training set)
  \item mu_test - Patient-level estimates (test set)
}
}
\description{
Wrapper function to train a patient-level estimate (ple) model. Used directly in PRISM
and can be used to directly fit a ple model by name.
}
\examples{
\donttest{
library(StratifiedMedicine)
## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

# Fit ple_ranger directly (treatment-specific ranger models) #
mod1 = ple_ranger(Y, A, X, Xtest=X)
summary(mod1$mu_train)

# Fit through ple_train wrapper #
mod2 = ple_train(Y=Y, A=A, X=X, Xtest=X, ple="ple_ranger" )
summary(mod2$mu_train)
}


}
\seealso{
\code{\link{PRISM}}
}
