% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_cox.R
\name{param_cox}
\alias{param_cox}
\title{Parameter Estimation: Cox Regression}
\usage{
param_cox(Y, A, X, mu_hat, Subgrps, alpha_ovrl, alpha_s,
  combine = "adaptive", ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{mu_hat}{Patient-level estimates (See PLE_models)}

\item{Subgrps}{Identified subgroups (can be the overall population)}

\item{alpha_ovrl}{Two-sided alpha level for overall population}

\item{alpha_s}{Two-sided alpha level at subgroup}

\item{combine}{For overall population, method of combining subgroup-specific results.
Default is "adaptive", "SS" corresponds to sample size weighting.}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Data-set with parameter estimates (log hazard ratio) and corresponding
variability metrics, for overall and subgroups. Subgrps=0 corresponds to the overall
population by default.
 \itemize{
  \item param.dat - Parameter estimates and variability metrics (est=logHR, 
  SE=SE(logHR), LCL/UCL = lower/upper confidence limit on logHR scale, pval = p-value).
  }
}
\description{
For each identified subgroup, fit separate cox regression models. Point-estimates and
variability metrics in the overall population are obtained by aggregating subgroup
specific results (adaptive weighting or sample size weighting).
}
\examples{
\donttest{
library(StratifiedMedicine)
# Survival Data #
require(TH.data); require(coin)

# MOB-Weibull Subgroup Model ##
res_weibull = submod_train(Y, A, X, Xtest=X, family="survival",
                            submod="submod_weibull")
plot(res_weibull$mod)

## Parameter-Estimation ##
params = param_cox(Y, A, X, Subgrps = res_weibull$Subgrps.train, alpha_ovrl=0.05,
                   alpha_s=0.05)
params
}

}
\seealso{
\code{\link{param_combine}}
}
