% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRISM_train.R
\name{PRISM_train}
\alias{PRISM_train}
\title{PRISM (Train): Patient Response Identifier for Stratified Medicine}
\usage{
PRISM_train(Y, A, X, Xtest = NULL, family = "gaussian",
  filter = "filter_glmnet", ple = NULL, submod = NULL,
  param = NULL, alpha_ovrl = 0.05, alpha_s = 0.05,
  filter.hyper = NULL, ple.hyper = NULL, submod.hyper = NULL,
  param.hyper = NULL, verbose = TRUE)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (ex: a=1,...,A, should be numeric). Default is NULL, which
searches for prognostic variables (Y~X).}

\item{X}{Covariate space. Variables types (ex: numeric, factor, ordinal) should be set
to align with subgroup model (submod argument). For example, for lmtree, binary variables
coded as numeric (ex: 0, 1) are treated differently than the corresponding factor version
(ex: "A", "B"). Filter and PLE models provided in the StratifiedMedicine package can
accomodate all variable types.}

\item{Xtest}{Test set. Default is NULL which uses X (training set). Variable types should
match X.}

\item{family}{Outcome type. Options include "gaussion" (default), "binomial", and "survival".}

\item{filter}{Maps (Y,A,X) => (Y,A,X.star) where X.star has potentially less
covariates than X. Default is "filter_glmnet", "None" uses no filter.}

\item{ple}{PLE (Patient-Level Estimate) function. Maps the observed data to PLEs.
(Y,A,X) ==> PLE(X). Default for is "ple_ranger". For continuous/binomial outcome data,
this fits treatment specific random forest models. For survival outcome data, this 
fits a single forest, with expanded covariate space (A, X, X*A). 
(treatment-specific random forest models).  "None" uses no ple.}

\item{submod}{Subgroup identification model function. Maps the observed data and/or PLEs
to subgroups. Default of "gaussian"/"binomial" is "submod_lmtree" (MOB with OLS loss).
Default for "survival" is "submod_weibull" (MOB with weibull loss). "None" uses no 
submod.}

\item{param}{Parameter estimation and inference function. Based on the discovered subgroups,
perform inference through the input function (by name). Default for "gaussian"/"binomial" is
"param_PLE", default for "survival" is "param_cox".}

\item{alpha_ovrl}{Two-sided alpha level for overall population. Default=0.05}

\item{alpha_s}{Two-sided alpha level at subgroup level. Default=0.05}

\item{filter.hyper}{Hyper-parameters for the Filter function (must be list). Default is NULL.}

\item{ple.hyper}{Hyper-parameters for the PLE function (must be list). Default is NULL.}

\item{submod.hyper}{Hyper-parameters for the SubMod function (must be list). Default is NULL.}

\item{param.hyper}{Hyper-parameters for the Param function (must be list). Default is NULL.}

\item{verbose}{Detail progress of PRISM? Default=TRUE}
}
\value{
Trained PRISM object. Includes filter, ple, submod, and param outputs.
 \itemize{
  \item filter.mod - Filter model
  \item filter.vars - Variables remaining after filtering
  \item ple.fit - Fitted ple model (model fit, other fit outputs)
  \item mu_train - Patient-level estimates (train)
  \item mu_test - Patient-level estimates (test)
  \item submod.fit - Fitted submod model (model fit, other fit outputs)
  \item Subgrps.train - Training data-set with identified subgroups
  \item Subgrps.test - Test data-set with identified subgroups
  \item Rules - Subgroup rules / definitions
  \item param.dat - Parameter estimates and variablity metrics (depends on param)
}
}
\description{
Train the PRISM algorithm given a training set (Y, A, X) and test set (Xtest). 
Used directly in \code{PRISM} and \code{PRISM_resamp}.
}
