% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submod_train.R
\name{submod_train}
\alias{submod_train}
\title{Subgroup Identification: Train Model}
\usage{
submod_train(Y, A, X, Xtest, mu_train = NULL, family = "gaussian",
  submod, hyper = NULL, ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{Xtest}{Test set}

\item{mu_train}{Patient-level estimates (See PLE_models). Default=NULL}

\item{family}{Outcome type ("gaussian", "binomial", "survival"). Default="gaussian".}

\item{submod}{Subgroup identification (submod) function. Maps the observed data and/or
PLEs to subgroups.}

\item{hyper}{Hyper-parameters for submod (must be list). Default is NULL.}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Trained subgroup model and subgroup predictions/estimates for train/test sets.

 \itemize{
  \item mod - trained subgroup model
  \item Subgrps.train - Identified subgroups (training set)
  \item Subgrps.test - Identified subgroups (test set)
  \item pred.train - Predictions (training set)
  \item pred.test - Predictions (test set)
  \item Rules - Definitions for subgroups, if provided in fitted submod output.
}
}
\description{
Wrapper function to train a subgroup model (submod). Used directly in PRISM and can
be used to directly fit a submod model by name.
}
\examples{
library(StratifiedMedicine)
## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

# Fit submod_lmtree directly #
mod1 = submod_lmtree(Y, A, X, Xtest=X)
plot(mod1$mod)

# Fit through submod_train wrapper #
mod2 = submod_train(Y=Y, A=A, X=X, Xtest=X, submod="submod_lmtree")
plot(mod2$fit$mod)


}
\seealso{
\code{\link{PRISM}}
}
