% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_sta_xml.R
\name{gen_sta_xml}
\alias{gen_sta_xml}
\title{Generate STICS sta xml file(s) from a template or an input file}
\usage{
gen_sta_xml(
  param_df,
  file = NULL,
  out_dir,
  stics_version = "latest",
  param_table = lifecycle::deprecated(),
  sta_in_file = lifecycle::deprecated(),
  out_path = lifecycle::deprecated()
)
}
\arguments{
\item{param_df}{A table (df, tibble) containing the values of the parameters
to use (see details)}

\item{file}{Path of a sta xml file to be used as a template. Optional,
if not provided, the function will use a standard template depending
on the STICS version.}

\item{out_dir}{Path of the directory where to generate the file(s).}

\item{stics_version}{Name of the STICS version. Optional, used if
the \code{file} argument is not provided. In this case the function uses a
standard template associated to the STICS version.}

\item{param_table}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{param_table} is no
longer supported, use \code{param_df} instead.}

\item{sta_in_file}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{sta_in_file} is no
longer supported, use \code{file} instead.}

\item{out_path}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{out_path} is no
longer supported, use \code{out_dir} instead.}
}
\value{
an invisible xml_document object or a list of
}
\description{
Generate STICS sta xml file(s) from a template or an input file
}
\details{
Please see \code{get_stics_versions_compat()} for the full list of
STICS versions that can be used for the argument \code{stics_version}.

\code{param_df} is a \code{data.frame} with the following format:\tabular{lrrrrr}{
   Sta_name \tab zr \tab NH3ref \tab latitude \tab patm \tab aclim \cr
   climatex_sta.xml \tab 2.5 \tab 0 \tab 49 \tab 1000 \tab 20 \cr
   climatex2_sta.xml \tab 2.8 \tab 0 \tab 49 \tab 1000 \tab 20 \cr
   climatex3_sta.xml \tab 2.2 \tab 0 \tab 49 \tab 1000 \tab 20 \cr
}


The first column gives the sta file name (to be generated),
all following columns give the parameter value to put in the file,
and each line denotes a separate sta file (for e.g. several USMs).

The first column name must contain the keyword sta or Sta or STA
as a prefix to be detected (as shown in the table extract above).

If not given (the default, \code{NULL}), the function returns the template as is.
}
\examples{
xl_path <- download_usm_xl(file = "inputs_stics_example.xlsx")
sta_param_df <- read_params_table(file = xl_path, sheet_name = "Station")
gen_sta_xml(out_dir = tempdir(), param_df = sta_param_df)

}
