% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection_functions.R
\name{sim.data.for.mod.selection}
\alias{sim.data.for.mod.selection}
\title{Simulate data at specified parameter values for doing model selection}
\usage{
sim.data.for.mod.selection(n.muts, coes.to.sim, sigs.to.sim, mods.to.sim,
  d.true, d.range, w.wt, wts, outpath, n.reps.ea, coe.sim.model = "identical",
  coe.dist.par = NA)
}
\arguments{
\item{n.muts}{Number of mutations to simulate. Vector of the form \code{c(3,4,5)}.}

\item{coes.to.sim}{Coefficient values to simulate. Vector of the form \code{c(0.1, 0.3, 0.5)}.}

\item{sigs.to.sim}{Sigma values to simulate. Vector of the form \code{c(0.02, 0.05, 0.08)}.}

\item{mods.to.sim}{Models to simulate under. Vector with model names of the form c("stick", "mult", "add").}

\item{d.true}{True value of d.}

\item{d.range}{Range of possible values for d. If estimate is outside this, estimate is not considered valid.}

\item{w.wt}{Wild type fitness.}

\item{wts}{Weights when estimating coefficients and d.}

\item{outpath}{Full path including file name to write results}

\item{n.reps.ea}{Number of simulated-fit datasets per parametric condition}

\item{coe.sim.model}{Coefficient simulation model. Possible values: "identical" means all coefficients take same value-- from coe.v.
"uniform" indicates to  sample individual coefficients from a uniform with mean given by coe.v and distributed U(coe.v-coe.dist.par, coe.v+coe.dist.parm).
"normal" means sample coefficients from normal distribution with mean from coe.v and sigma given by coe.dist.par.
Default = "identical".}

\item{coe.dist.par}{Coefficient distribution parameter. If coe.sim.model=="uniform", then uniform is U(-coe.dist.par, +coe.dist.parm).
If coe.sim.model=="normal", then distributed normal with mean given by coe.v and sigma give by coe.dist.parm.}
}
\value{
Nothing. Instead results are written to \code{outpath} file for later analysis.
}
\description{
Simulate data at specified parameter values for doing model selection
}
\details{
Function loops over all parametric combinations and simulates datasets. For each dataset it
fits to each of the models and outputs a row of metrics that summarize the fits.
}

