% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_CovMat.R
\name{construct_CovBlk}
\alias{construct_CovBlk}
\title{Construct a Single Block of the Covariance Matrix}
\usage{
construct_CovBlk(sigma, tau = NULL, eta = NULL, AR = NULL, rho = NULL)
}
\arguments{
\item{sigma}{numeric (vector of length `timepoints`),
residual error}

\item{tau}{numeric (vector of length `timepoints`),
standard deviation of random intercepts}

\item{eta}{numeric (vector of length `timepoints`),
standard deviation of random slope}

\item{AR}{numeric, vector containing up to three values, each between 0 and 1.
Defaults to NULL. It defines the AR(1)-correlation of random effects.
The first element corresponds to the cluster intercept, the second to the
treatment effect and the third to subject specific intercept.
If only one element is provided, autocorrelation of all random effects is
assumed to be the same.
*Currently not compatible with `rho`!=0 !*}

\item{rho}{numeric (scalar), correlation of `tau` and `eta`. The default is no correlation.}
}
\value{
a block of a covariance matrix,
corresponding to intra-cluster covariance over time for one cluster
}
\description{
Constructs the covariance matrix
for multiple measurements of the same cluster.
This function is usually called by `construct_CovMat` and is
 not designed to be used directly.
}
\examples{
construct_CovBlk(sigma=rep(2,5), tau=rep(1,5))

construct_CovBlk(sigma=rep(2,5),
                tau=rep(.5,5), eta=c(0,0,1,1,1),
                AR=c(.5, 1))
}
