% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{steiner_simulation}
\alias{steiner_simulation}
\title{Execute Steiner Algorithms and calculate parameters of output trees}
\usage{
steiner_simulation(type, repeattimes = 70, optimize = TRUE, graph, ter_list)
}
\arguments{
\item{type}{a character vector, which indicates types of algorithms to perform. Can be
"EXA", "SP", "KB", "RSP", "SPM" or "ASP".}

\item{repeattimes}{a numeric scalar to specify "RSP" algorithm; number of times the optimization procedure is repeated.}

\item{optimize}{a logical scalar to specify all algorithms in type variable (ignored for "EXA"); if TRUE, an optimization
of the resultant steiner tree is performed, otherwise nothing is done.}

\item{graph}{an igraph graph; should be undirected, otherwise it is converted to undirected.}

\item{ter_list}{a list each element of which contains a numeric or character vector with ids of terminals or
a character vector with names of vertices (only if vertices have name attribute). Therefore, length of
ter_list declares a number of experiments to perform with different terminal sets
for each type of algorithm.}
}
\value{
List, each element of which corresponds to specific algorithms type. Each element of a list also
        is a list and contains a named vector of evaluated parameters of steiner tree
        (runtime, edges_num, vert_num, trees_num, term_freq, edge_den). Number of sublist corresponds to
        number of terminal set in ter_list.
}
\description{
This function executes given Steiner Algorithms and calculates such parameters as 
             runtime of each algorithm, number of edges, number of vertices, terminal frequency, edge density of
             resultant Steiner tree and number of trees in case of "EXA" or "SPM" algorithm. Wraps steinertree function.
}
\details{
As a ter_list, a vector can be passed. In this case it is converted to a list containing only one element.
}
\examples{
g <- graph("Cubical")

steiner_simulation(type = c("SP", "KB", "SPM"),
                   graph = g,
                   ter_list = generate_st_samples(graph = g,
                                                  ter_number = c(2, 3),
                                                  prob = c(0.1, 0.2)))
                   
steiner_simulation(type = c("EXA", "RSP"),
                   graph = g,
                   ter_list = c(1, 3, 8))

}
\references{
1. Afshin Sadeghi and Holger Froehlich, "Steiner tree methods for optimal sub-network
               identification: an empirical study", BMC Bioinformatics 2013 14:144
}
\seealso{
\code{\link{generate_st_samples}}, \code{\link{steinertree}}
}
