% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialGEV_sample.R
\name{spatialGEV_sample}
\alias{spatialGEV_sample}
\title{Get posterior parameter draws from a fitted GEV-GP model.}
\usage{
spatialGEV_sample(model, n_draw, observation = FALSE, loc_ind = NULL)
}
\arguments{
\item{model}{A fitted spatial GEV model object of class \code{spatialGEVfit}}

\item{n_draw}{Number of draws from the posterior distribution}

\item{observation}{whether to draw from the posterior distribution of the GEV observation?}

\item{loc_ind}{A vector of location indices to sample from. Default is all locations.}
}
\value{
An object of class \code{spatialGEVsam}, which is a list of matrices containing the
joint posterior draws of the parameters and optionally the GEV observations.
}
\description{
Get posterior parameter draws from a fitted GEV-GP model.
}
\examples{
\donttest{
library(SpatialGEV)
a <- simulatedData$a
logb <- simulatedData$logb
logs <- simulatedData$logs
y <- simulatedData$y
locs <- simulatedData$locs
n_loc <- nrow(locs)
beta_a <- mean(a); beta_b <- mean(logb)
fit <- spatialGEV_fit(y = y, locs = locs, random = "ab",
                      init_param = list(beta_a = beta_a,
                                        beta_b = beta_b,
                                        a = rep(0, n_loc), 
                                        log_b = rep(0, n_loc), 
                                        s = 0,
                                        log_sigma_a = 0, 
                                        log_kappa_a = 0,
                                        log_sigma_b = 0, 
                                        log_kappa_b = 0),
                      reparam_s = "positive",
                      kernel = "matern",
                      silent = TRUE) 
sam <- spatialGEV_sample(model = fit, n_draw = 100, 
                         observation = TRUE, loc_ind=1:10)
print(sam)
summary(sam)
}
}
