% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_exp.R
\name{kernel_exp}
\alias{kernel_exp}
\title{Exponential covariance function}
\usage{
kernel_exp(x, sigma, ell, X1 = NULL, X2 = NULL)
}
\arguments{
\item{x}{Distance measure.}

\item{sigma}{The amplitude parameter (scalar) with the constraint of \code{sigma > 0}}

\item{ell}{The smoothness parameter (scalar) with the constraint of \code{ell > 0}.}

\item{X1}{A \verb{n1 x 2} matrix containing the coordinates of location set 1.
If \code{x} is not provided, \code{X1} and \code{X2} should be provided for calculating their distance.}

\item{X2}{A \verb{n2 x 2} coordinate matrix.}
}
\value{
A matrix or a scalar of exponential covariance depending on the type of \code{x} or
whether \code{X1} and \code{X2} are used instead.
}
\description{
Exponential covariance function
}
\details{
Let x = dist(x_i, x_j).\preformatted{cov(i,j) = sigma*exp(-x/ell)
}
}
\examples{
X1 <- cbind(runif(10, 1, 10), runif(10, 10, 20))
X2 <- cbind(runif(5, 1, 10), runif(5, 10, 20))

kernel_exp(sigma=2, ell=1, X1=X1, X2=X2)

kernel_exp(as.matrix(stats::dist(X1)), sigma=2, ell=1)
}
