% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batty_karlstrom_entropy.R
\name{batty}
\alias{batty}
\title{Batty's entropy.}
\usage{
batty(data, data.assign, is.pointdata = FALSE, category, win = NULL,
  G.coords)
}
\arguments{
\item{data}{A data matrix or vector, can be numeric, factor, character, ...
If the dataset is a point pattern, \code{data} is the mark vector.}

\item{data.assign}{A three column matrix, containing the data coordinates (centroids when pixels)
and the id of the corresponding sub-area. Provided by user or returned by \code{\link[=areapart]{areapart()}}.}

\item{is.pointdata}{Logical: \code{T} if data are a point pattern, \code{F} if they are pixels.}

\item{category}{A character string, the exact name of the category for which Batty's spatial
entropy is computed, as in \code{data}.}

\item{win}{An \code{owin} object (see package \code{spatstat}), the observation area.
Only needed for lattice data.}

\item{G.coords}{A point pattern (an object of class \code{ppp} see package \code{spatstat}),
or a two column matrix with the area centroids' coordinates.  Provided by user or returned by \code{\link[=areapart]{areapart()}}.}
}
\value{
Batty's spatial entropy value, as well as a table with information
about each sub-area:
\itemize{
\item \code{area.id} the sub-area id
\item \code{abs.freq} the number of points/pixels presenting the category of interest
for each sub-area
\item \code{rel.freq} the proportion of points/pixels presenting the category of interest
in each sub-area, with regard to the total number of points/pixels with the
category of interest
\item \code{Tg} the sub-area size.
}
}
\description{
This function computes Batty's spatial entropy, following Batty (1976), see also Altieri et al (2017)
(references are under the topic \code{\link{SpatEntropy}}).
}
\details{
Batty's spatial entropy measures the heterogeneity in the spatial distribution
of a phenomenon of interest, with regard to an area partition. It is high
when the phenomenon is equally intense over the sub-areas, and low when
it concentrates in one or few sub-areas. This function starts from the output
of \code{\link[=areapart]{areapart()}} and allows to compute Batty's entropy as
\deqn{H=\sum p_g \log(T_g/p_g)}
where \eqn{p_g} is the probability of occurrence of the phenomenon over sub-area \eqn{g},
and \eqn{T_g} is the sub-area size.
When data are categorical, the phenomenon of interest corresponds to
one category, which must be specified. If data are an unmarked
point pattern, a fake mark vector must be created with the same category for all points.
}
\examples{
#LATTICE DATA
data.lat=matrix(sample(c("a","b","c"), 100, replace=TRUE), nrow=10)
ccc=coords_pix(area=square(10), nrow=10, ncol=10)
partition=areapart(square(10), G=5, data.coords=ccc)
batty(data.lat, partition$data.assign, category="a",
win=square(10), G.coords=partition$G.coords)
plot_areapart(partition$data.assign, square(10), is.pointdata=FALSE,
add.data=TRUE, data.bin=TRUE, category="a",
data=data.lat, G.coords=partition$G.coords, main="")

#POINT DATA
data.pp=runifpoint(100, win=square(10))
marks(data.pp)=sample(c("a","b","c"), 100, replace=TRUE)
ccc=coords(data.pp)
partition=areapart(square(10), G=4, data.coords=ccc)
batty(marks(data.pp), partition$data.assign, is.pointdata=TRUE,
category="b", G.coords=partition$G.coords)
plot_areapart(partition$data.assign, square(10), is.pointdata=TRUE,
add.data=TRUE, data.bin=TRUE, category="b",
data=data.pp, G.coords=partition$G.coords, main="")

}
