% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TSLasso.R
\name{TSLasso}
\alias{TSLasso}
\title{Two-stage hybrid LASSO model.}
\usage{
TSLasso(x, y, lambda.candidates = list(seq(0.001, 5, by = 0.01)),
  kfold = 10)
}
\arguments{
\item{x}{the predictor matrix}

\item{y}{the response variable, a numeric vector with values of 0 and 1}

\item{lambda.candidates}{the lambda candidates in the cv.lqa function, with the default values from 0.001 to 5 by=0.01}

\item{kfold}{the K-fold cross validation, with the default value 10}
}
\description{
This function performs a LASSO logistic regression model using a two-stage hybrid procedure.
}
\examples{
library(datasets)
head(iris)
X <- as.matrix(subset(iris,iris$Species!="virginica")[,-5])
Y <- as.numeric(ifelse(subset(iris,iris$Species!="virginica")[,5]=='versicolor', 0, 1))
# Fit a two-stage hybrid LASSO (TSLasso) logistic regression model.
# The parameters of lambda.candidates in the following example are set as small values to
# reduce the running time, however the default values are proposed.
TSLasso.fit <- TSLasso(x=X, y=Y, lambda.candidates=list(seq(0.1, 1, by=0.05)), kfold=3)
# Variables selected by the TSLasso model.
TSLasso.fit$var.selected
# Coefficients of the selected variables.
TSLasso.fit$var.coef
}
\references{
[1] Guo, P., Zeng, F., Hu, X., Zhang, D., Zhu, S., Deng, Y., & Hao, Y. (2015). Improved Variable
Selection Algorithm Using a LASSO-Type Penalty, with an Application to Assessing Hepatitis B
Infection Relevant Factors in Community Residents. PLoS One, 27;10(7):e0134151.
}

