% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\docType{methods}
\name{randomPolygons}
\alias{randomPolygons}
\title{randomPolygons}
\usage{
randomPolygons(ras = raster(extent(0, 15, 0, 15), res = 1), numTypes = 2,
  ...)
}
\arguments{
\item{ras}{A raster that whose extent will be used for the randomPolygons}

\item{numTypes}{Numeric value. The number of unique polygon types to use.
This will be overridden by \code{p}, \code{A} or
\code{minpatch}, if any of these are vectors.}

\item{...}{Other arguments passed to spread. No known uses currently.}
}
\value{
A map of extent \code{ext} with random polygons.
}
\description{
Produces a raster of with random polygons. These are built with the
\code{\link{spread}} function internally.
}
\examples{
Ras <- randomPolygons(numTypes = 5)
if (interactive()) Plot(Ras, cols = c("yellow", "dark green", "blue", "dark red"), new = TRUE)

library(raster)
# more complex patterning, with a range of patch sizes
a = randomPolygons(numTypes = 400, raster(extent(0, 50, 0, 50), res = 1))
a[a<320] <- 0
a[a>=320] <- 1
aHist <- hist(table(getValues(clump(a, directions = 4))), plot = FALSE)
if (interactive()) Plot(a, aHist, new = TRUE)

}
\references{
Saura, S. and Martinez-Millan, J. (2000) Landscape patterns simulation with a
modified random clusters method. Landscape Ecology, 15, 661--678.
}
\seealso{
\code{\link{spread}} and \code{\link{raster}}
}

