% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveLoadSimList.R
\name{saveSimList}
\alias{saveSimList}
\alias{saveSim}
\title{Save a whole \code{simList} object to disk}
\usage{
saveSimList(
  sim,
  filename,
  projectPath = getwd(),
  outputs = TRUE,
  inputs = TRUE,
  cache = FALSE,
  envir,
  ...
)
}
\arguments{
\item{sim}{Either a \code{simList} or a character string of the name
of a \code{simList} that can be found in \code{envir}.
Using a character string will assign that object name to the saved
\code{simList}, so when it is recovered it will be given that name.}

\item{filename}{Character string with the path for saving \code{simList} to or
reading the \code{simList} from. Currently, only \code{.rds} and \code{.qs} file types are supported.}

\item{projectPath}{Should be the "top level" or project path for the \code{simList}.
Defaults to \code{getwd()}. All other paths will be made relative with respect to
this if nested within this.}

\item{outputs}{Logical. If \code{TRUE}, all files identified in
\code{outputs(sim)} will be included in the zip.}

\item{inputs}{Logical. If \code{TRUE}, all files identified in
\code{inputs(sim)} will be included in the zip.}

\item{cache}{Logical. Not yet implemented. If \code{TRUE}, all files in \code{cachePath(sim)}
will be included in the archive.
Defaults to \code{FALSE} as this could be large, and may include many out of date elements.
See Details.}

\item{envir}{If \code{sim} is a character string, then this must be provided.
It is the environment where the object named \code{sim} can be found.}

\item{...}{Additional arguments. See Details.}
}
\value{
Invoked for side effects of saving a \code{.qs} or \code{.rds} file,
or a \code{.tar.gz} (non-Windows) or \code{.zip} (Windows).
}
\description{
Saving a \code{simList} may not work using the standard approaches
(e.g., \code{save}, \code{saveRDS}, and \code{qs::qsave}).
There are 2 primary reasons why this doesn't work as expected:
the \code{activeBindings} that are in place within modules
(these allow the \code{mod} and \code{Par} to exist), and file-backed objects,
such as \code{SpatRaster} and \verb{Raster*}.
Because of these, a user should use \code{saveSimList} and \code{loadSimList}.
These will save the object and recover the object using the \code{filename} supplied,
if there are no file-backed objects.
If there are file-backed objects, then it will save an archive
(default is \code{.tar.gz} using the \code{archive} package for non-Windows and \code{\link[=zip]{zip()}}
if using Windows, as there is currently an unidentified bug in \verb{archive*} on Windows).
The user does not need to specify the filename any differently,
as the code will search based on the filename without the file extension.
}
\details{
There is a family of 2 functions that are mutually useful for saving and
loading \code{simList} objects and their associated files (e.g., file-backed
\verb{Raster*}, \code{inputs}, \code{outputs}, \code{cache}) \code{\link[=saveSimList]{saveSimList()}}, \code{\link[=loadSimList]{loadSimList()}}.

Additional arguments may be passed via \code{...}, including:
\itemize{
\item \code{files}: logical indicating whether files should be included in the archive.
if \code{FALSE}, will override \code{cache}, \code{inputs}, \code{outputs}, setting them to \code{FALSE}.
\item \code{symlinks}: a named list of paths corresponding to symlinks, which will be used to substitute
normalized absolute paths of files.
Names should correspond to the names in \code{paths()};
values should be project-relative paths.
E.g., \code{list(cachePath = "cache", inputPath = "inputs", outputPath = "outputs")}.
}
}
\seealso{
\code{\link[=loadSimList]{loadSimList()}}
}
