% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\name{progressInterval}
\alias{progressInterval}
\alias{progressInterval,simList-method}
\alias{progressInterval<-}
\alias{progressInterval<-,simList-method}
\alias{progressType}
\alias{progressType,simList-method}
\alias{progressType<-}
\alias{progressType<-,simList-method}
\title{Get and set simulation progress bar details}
\usage{
progressInterval(sim)

\S4method{progressInterval}{simList}(sim)

progressInterval(sim) <- value

\S4method{progressInterval}{simList}(sim) <- value

progressType(sim)

\S4method{progressType}{simList}(sim)

progressType(sim) <- value

\S4method{progressType}{simList}(sim) <- value
}
\arguments{
\item{sim}{A \code{simList} object from which to extract element(s) or
in which to replace element(s).}

\item{value}{The parameter value to be set (in the corresponding \code{module} and \code{param}).}
}
\description{
The progress bar can be set in two ways in SpaDES. First, by setting values
in the .progress list element in the params list element passed to \code{\link[=simInit]{simInit()}}.
Second, at the \code{\link[=spades]{spades()}} call itself, which can be simpler. See examples.
}
\details{
Progress Bar:
Progress type can be one of  \code{"text"}, \code{"graphical"}, or \code{"shiny"}.
Progress interval can be a numeric.
These both can get set by passing a
\code{.progress = list(type = "graphical", interval = 1)} into the \code{simInit} call.
See examples.
}
\examples{
\dontrun{
mySim <- simInit(
  times = list(start=0.0, end=100.0),
  params = list(.globals = list(stackName = "landscape"),
  .progress = list(type = "text", interval = 10),
  checkpoint = list(interval = 10, file = "chkpnt.RData")),
  modules = list("randomLandscapes"),
  paths = list(modulePath = system.file("sampleModules", package = "SpaDES.core")))

# progress bar
progressType(mySim) # "text"
progressInterval(mySim) # 10

# parameters
params(mySim) # returns all parameters in all modules
              # including .global, .progress, checkpoint
globals(mySim) # returns only global parameters

# checkpoint
checkpointFile(mySim) # returns the name of the checkpoint file
                      # In this example, "chkpnt.RData"
checkpointInterval(mySim) # 10
}
}
\seealso{
Other functions to access elements of a 'simList' object: 
\code{\link{.addDepends}()},
\code{\link{doEvent.checkpoint}()},
\code{\link{envir}()},
\code{\link{events}()},
\code{\link{globals}()},
\code{\link{inputs}()},
\code{\link{modules}()},
\code{\link{objs}()},
\code{\link{packages}()},
\code{\link{params}()},
\code{\link{paths}()},
\code{\link{times}()}
}
\concept{functions to access elements of a 'simList' object}
