% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\docType{data}
\name{emptyEventList}
\alias{emptyEventList}
\alias{.emptyEventListDT}
\alias{.singleEventListDT}
\alias{.emptyEventList}
\alias{.emptyEventList,numeric,character,character,numeric-method}
\alias{.emptyEventList,missing,missing,missing,missing-method}
\alias{.emptyEventListCols}
\title{Blank (template) event list}
\format{
An object of class \code{data.table} (inherits from \code{data.frame}) with 0 rows and 4 columns.

An object of class \code{data.table} (inherits from \code{data.frame}) with 1 rows and 4 columns.

An object of class \code{character} of length 4.
}
\usage{
.emptyEventListDT

.singleEventListDT

.emptyEventList(eventTime, moduleName, eventType, eventPriority)

\S4method{.emptyEventList}{numeric,character,character,numeric}(eventTime, moduleName, eventType, eventPriority)

\S4method{.emptyEventList}{missing,missing,missing,missing}()

.emptyEventListCols
}
\arguments{
\item{eventTime}{The time the event is to occur.}

\item{moduleName}{The module from which the event is taken.}

\item{eventType}{A character string for the programmer-defined event type.}

\item{eventPriority}{The priority given to the event.}
}
\value{
Returns an empty event list.
}
\description{
Internal function called from \code{spades}, returning an empty event list.
}
\details{
Event lists are sorted (keyed) first by time, second by priority.
Each event is represented by a \code{\link{data.table}} row consisting of:
\tabular{ll}{
\code{eventTime} \tab The time the event is to occur.\cr
\code{moduleName} \tab The module from which the event is taken.\cr
\code{eventType} \tab A character string for the programmer-defined event type.\cr
\code{eventPriority} \tab The priority given to the event. \cr
}
}
\author{
Alex Chubaty
}
\keyword{internal}
