% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-define.R
\docType{methods}
\name{expectsInput}
\alias{expectsInput}
\alias{expectsInput,ANY,ANY,ANY,ANY-method}
\alias{expectsInput,character,character,character,character-method}
\alias{expectsInput,character,character,character,missing-method}
\title{Define an input object that the module expects.}
\usage{
expectsInput(objectName, objectClass, desc, sourceURL, ...)

\S4method{expectsInput}{ANY,ANY,ANY,ANY}(objectName, objectClass, desc,
  sourceURL, ...)


  \S4method{expectsInput}{character,character,character,character}(objectName,
  objectClass, desc, sourceURL, ...)

\S4method{expectsInput}{character,character,character,missing}(objectName,
  objectClass, desc, sourceURL, ...)
}
\arguments{
\item{objectName}{Character string to define the input object's name.}

\item{objectClass}{Character string to specify the input object's class.}

\item{desc}{Text string providing a brief description of the input object.}

\item{sourceURL}{Character string to specify an URL to reach the input object,
default is \code{NA}.}

\item{...}{Other specifications of the input object.}
}
\value{
A \code{data.frame} suitable to be passed to \code{inputObjects} in a
module's metadata.
}
\description{
Used to specify an input object's name, class, description, source url and
other specifications.
}
\examples{
inputObjects <- dplyr::bind_rows(
  expectsInput(objectName = "inputObject1", objectClass = "character",
               desc = "this is for example", sourceURL = "not available"),
  expectsInput(objectName = "inputObject2", objectClass = "numeric",
               desc = "this is for example", sourceURL = "not available",
               otherInformation = "I am the second input object")
)

}
\author{
Yong Luo
}
