% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopifnotMsg.R
\name{stopifnotMsg}
\alias{stopifnotMsg}
\title{Check multiple conditions and return coresponding error messages}
\usage{
stopifnotMsg(..., level = 1)
}
\arguments{
\item{\dots}{Pairs of logical conditions and error messages. See Examples.}

\item{level}{Whole number indicating how far back in the call stack the error should be attributed to.
\code{level = 1} goes back to the calling function, \code{level = 2} goes back 2 levels, etc.
See examples.}
}
\value{
A call to \code{\link{stop}} with the error messages from each condition that was \code{FALSE}.  If all
conditions are \code{TRUE}, returns \code{NULL}.
}
\description{
A more flexible version of \code{\link{stopifnot}} that allows you to control the error message returned by
each condition that doesn't test true
}
\examples{
# A simple function
aFunction <- function(x, a = 10, b = "text") {

  # Check the arguments of the function
  stopifnotMsg(is.numeric(x),   "'x' must be numeric",
               is.numeric(a),   "'a' must be numeric",
               a > 9,           "'a' must be 10 or more",
               is.character(b), "'b' must be character")

  return(paste(x, a, b, sep = " -- "))

}

# This should run without error
aFunction(12, a = 13, b = "new")

\dontrun{
# This should produce an error with 3 messages:
aFunction("new", a = 7, b = 5)

# And this should produce an error with 1 message:
aFunction(33, a = "bad")
}

### This illustrates how the 'level' argument works

# A check function that will be called within another
check <- function(a, lev) {
  stopifnotMsg(is.numeric(a), "a must be numeric", level = lev)
}

# A function that uses the check.
f <- function(a, lev = 1) {
  check(a, lev)
  return(a + 10)
}

\dontrun{
# Note how the error is attributed to 'check'
f("a")

# But if we change the level to 2, the error will be attributed to 'f'
f("a", lev = 2)
}
}
\author{
Landon Sego
}
