% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\docType{methods}
\name{plot,SimInf_model-method}
\alias{plot,SimInf_model-method}
\title{Display the outcome from a simulated trajectory}
\usage{
\S4method{plot}{SimInf_model}(x, legend = NULL, col = NULL,
  lty = NULL, lwd = 2, compartments = NULL, node = NULL,
  range = 0.5, ...)
}
\arguments{
\item{x}{The \code{model} to plot}

\item{legend}{The character vector to appear in the
legend. Default is to use the names of the compartments.}

\item{col}{The plotting color for each compartment. Default is
black.}

\item{lty}{The line type for each compartment. Default is the
sequence: 1=solid, 2=dashed, 3=dotted, 4=dotdash, 5=longdash,
6=twodash.}

\item{lwd}{The line width for each compartment. Default is 2.}

\item{compartments}{Character vector with the compartments in the
model to include in the plot. Default is \code{NULL}
i.e. include all compartments in the model.}

\item{node}{indices specifying the nodes to include when plotting
data. Plot one line for each node. Default (\code{node =
NULL}) is to extract data from all nodes and plot the median
count for the specified compartments.}

\item{range}{show the quantile range of the count in each
compartment. Default is to show the interquartile range
i.e. the middle 50\% of the count in transparent color. The
median value is shown in the same color. Use \code{range =
0.95} to show the middle 95\% of the count. To display
individual lines for each node, specify \code{range = FALSE}.}

\item{...}{Additional arguments affecting the plot produced.}
}
\description{
Plot either the median and the quantile range of the counts in all
nodes, or plot the counts in specified nodes.
}
\examples{
\dontrun{
## Create an 'SIR' model with 100 nodes and initialise
## it with 990 susceptible individuals and 10 infected
## individuals in each node. Run the model over 100 days.
model <- SIR(u0 = data.frame(S = rep(990, 100),
                             I = rep(10, 100),
                             R = rep(0, 100)),
             tspan = 1:100,
             beta = 0.16,
             gamma = 0.077)

## Run the model and save the result.
result <- run(model)

## Plot the median and interquartile range of the number
## of susceptible, infected and recovered individuals.
plot(result)

## Plot the median and the middle 95\\\% quantile range of the
## number of susceptible, infected and recovered individuals.
plot(result, range = 0.95)

## Plot the median and interquartile range of the  number
## of infected individuals.
plot(result, compartments = "I")

## Plot the number of susceptible, infected
## and recovered individuals in the first
## three nodes.
plot(result, node = 1:3, range = FALSE)

## Plot the number of infected individuals in the first node.
plot(result, compartments = "I", node = 1, range = FALSE)
}
}
