% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_model.R
\name{indegree}
\alias{indegree}
\title{Determine in-degree for each node in a model}
\usage{
indegree(model)
}
\arguments{
\item{model}{determine in-degree for each node in the model.}
}
\value{
vector with in-degree for each node.
}
\description{
The number of nodes with inward \emph{external transfer} events to
each node.
}
\examples{
## Create an 'SIR' model with 1600 nodes and initialize
## it with example data.
model <- SIR(u0 = u0_SIR(), tspan = 1:1460, events = events_SIR(),
             beta   = 0.16, gamma  = 0.077)

## Display indegree for each node in the model.
plot(indegree(model))
}
