% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{UnifyPeaks}
\alias{UnifyPeaks}
\title{Unify genomic ranges}
\usage{
UnifyPeaks(object.list, mode = "reduce")
}
\arguments{
\item{object.list}{A list of Seurat objects or ChromatinAssay objects}

\item{mode}{Function to use when combining genomic ranges. Can be "reduce"
(default) or "disjoin".
See \code{\link[GenomicRanges]{reduce}}
and \code{\link[GenomicRanges]{disjoin}}
for more information on these functions.}
}
\value{
Returns a GRanges object
}
\description{
Create a unified set of non-overlapping genomic ranges
from multiple Seurat objects containing single-cell
chromatin data.
}
\examples{
UnifyPeaks(object.list = list(atac_small, atac_small))
}
\concept{preprocessing}
\concept{utilities}
