% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/motifs.R
\name{ConvertMotifID}
\alias{ConvertMotifID}
\alias{ConvertMotifID.default}
\alias{ConvertMotifID.Motif}
\alias{ConvertMotifID.ChromatinAssay}
\alias{ConvertMotifID.Assay}
\alias{ConvertMotifID.StdAssay}
\alias{ConvertMotifID.Seurat}
\title{Convert between motif name and motif ID}
\usage{
ConvertMotifID(object, ...)

\method{ConvertMotifID}{default}(object, name, id, ...)

\method{ConvertMotifID}{Motif}(object, ...)

\method{ConvertMotifID}{ChromatinAssay}(object, ...)

\method{ConvertMotifID}{Assay}(object, ...)

\method{ConvertMotifID}{StdAssay}(object, ...)

\method{ConvertMotifID}{Seurat}(object, assay = NULL, ...)
}
\arguments{
\item{object}{A Seurat, ChromatinAssay, or Motif object}

\item{...}{Arguments passed to other methods}

\item{name}{A vector of motif names}

\item{id}{A vector of motif IDs. Only one of \code{name} and \code{id} should
be supplied}

\item{assay}{For \code{Seurat} object. Name of assay to use.
If NULL, use the default assay}
}
\value{
Returns a character vector with the same length and order as the
input. Any names or IDs that were not found will be stored as \code{NA}.
}
\description{
Converts from motif name to motif ID or vice versa. To convert common names
to IDs, use the \code{name} parameter. To convert IDs to common names, use
the \code{id} parameter.
}
\concept{motifs}
