% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{UnifyPeaks}
\alias{UnifyPeaks}
\title{Unify genomic ranges}
\usage{
UnifyPeaks(object.list, mode = "reduce", sep = c(":", "-"))
}
\arguments{
\item{object.list}{A list of Seurat objects}

\item{mode}{Function to use when combining genomic ranges. Can be "reduce" (default)
or "disjoin". See \code{\link[GenomicRanges]{reduce}} and \code{\link[GenomicRanges]{disjoin}}
for more information on these functions.}

\item{sep}{Separators to use to extract genomic ranges from object row names. To specify different
separators for different objects, pass a list of length equal to the length of \code{object.list}.}
}
\value{
Returns a GRanges object
}
\description{
Create a unified set of non-overlapping genomic ranges
from multiple Seurat objects containing single-cell
chromatin data.
}
\examples{
UnifyPeaks(object.list = list(atac_small, atac_small))
}
