% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{CellScatter}
\alias{CellScatter}
\alias{CellPlot}
\title{Cell-cell scatter plot}
\usage{
CellScatter(object, cell1, cell2, features = NULL, highlight = NULL,
  cols = NULL, pt.size = 1, smooth = FALSE, ...)
}
\arguments{
\item{object}{Seurat object}

\item{cell1}{Cell 1 name}

\item{cell2}{Cell 2 name}

\item{features}{Features to plot (default, all features)}

\item{highlight}{Features to highlight}

\item{cols}{Colors to use for identity class plotting.}

\item{pt.size}{Size of the points on the plot}

\item{smooth}{Smooth the graph (similar to smoothScatter)}

\item{...}{Ignored for now}
}
\value{
A ggplot object
}
\description{
Creates a plot of scatter plot of features across two single cells. Pearson
correlation between the two cells is displayed above the plot.
}
\examples{
CellScatter(object = pbmc_small, cell1 = 'ATAGGAGAAACAGA', cell2 = 'CATCAGGATGCACA')

}
