% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{DoHeatmap}
\alias{DoHeatmap}
\title{Feature expression heatmap}
\usage{
DoHeatmap(object, features = NULL, cells = NULL, group.by = "ident",
  group.bar = TRUE, disp.min = -2.5, disp.max = NULL,
  slot = "scale.data", assay = NULL, label = TRUE, size = 5.5,
  hjust = 0, angle = 45, raster = TRUE, combine = TRUE)
}
\arguments{
\item{object}{Seurat object}

\item{features}{A vector of features to plot, defaults to \code{VariableFeatures(object = object)}}

\item{cells}{A vector of cells to plot}

\item{group.by}{A vector of variables to group cells by; pass 'ident' to group by cell identity classes}

\item{group.bar}{Add a color bar showing group status for cells}

\item{disp.min}{Minimum display value (all values below are clipped)}

\item{disp.max}{Maximum display value (all values above are clipped); defaults to 2.5
if \code{slot} is 'scale.data', 6 otherwise}

\item{slot}{Data slot to use, choose from 'raw.data', 'data', or 'scale.data'}

\item{assay}{Assay to pull from}

\item{label}{Label the cell identies above the color bar}

\item{size}{Size of text above color bar}

\item{hjust}{Horizontal justification of text above color bar}

\item{angle}{Angle of text above color bar}

\item{raster}{If true, plot with geom_raster, else use geom_tile. geom_raster may look blurry on
some viewing applications such as Preview due to how the raster is interpolated. Set this to FALSE
if you are encountering that issue (note that plots may take longer to produce/render).}

\item{combine}{Combine plots into a single gg object; note that if TRUE; themeing will not work
when plotting multiple dimensions}
}
\value{
A ggplot object
}
\description{
Draws a heatmap of single cell feature expression.
}
\examples{
DoHeatmap(object = pbmc_small)

}
