% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{OldDoHeatmap}
\alias{OldDoHeatmap}
\title{Gene expression heatmap}
\usage{
OldDoHeatmap(object, cells.use = NULL, genes.use = NULL, disp.min = NULL,
  disp.max = NULL, draw.line = TRUE, do.return = FALSE,
  order.by.ident = TRUE, col.use = PurpleAndYellow(),
  slim.col.label = FALSE, group.by = NULL, remove.key = FALSE,
  cex.col = NULL, do.scale = TRUE, ...)
}
\arguments{
\item{object}{Seurat object}

\item{cells.use}{Cells to include in the heatmap (default is all cells)}

\item{genes.use}{Genes to include in the heatmap (ordered)}

\item{disp.min}{Minimum display value (all values below are clipped)}

\item{disp.max}{Maximum display value (all values above are clipped)}

\item{draw.line}{Draw vertical lines delineating cells in different identity
classes.}

\item{do.return}{Default is FALSE. If TRUE, return a matrix of scaled values
which would be passed to heatmap.2}

\item{order.by.ident}{Order cells in the heatmap by identity class (default
is TRUE). If FALSE, cells are ordered based on their order in cells.use}

\item{col.use}{Color palette to use}

\item{slim.col.label}{if (order.by.ident==TRUE) then instead of displaying
every cell name on the heatmap, display only the identity class name once
for each group}

\item{group.by}{If (order.by.ident==TRUE) default,  you can group cells in
different ways (for example, orig.ident)}

\item{remove.key}{Removes the color key from the plot.}

\item{cex.col}{positive numbers, used as cex.axis in for the column axis labeling.
The defaults currently only use number of columns}

\item{do.scale}{whether to use the data or scaled data}

\item{...}{Additional parameters to heatmap.2. Common examples are cexRow
and cexCol, which set row and column text sizes}
}
\value{
If do.return==TRUE, a matrix of scaled values which would be passed
to heatmap.2. Otherwise, no return value, only a graphical output
}
\description{
Draws a heatmap of single cell gene expression using the heatmap.2 function. Has been replaced by the ggplot2
version (now in DoHeatmap), but kept for legacy
}
\examples{
pbmc_small
OldDoHeatmap(object = pbmc_small, genes.use = pbmc_small@var.genes)

}
