% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_nets.R
\name{exportGeneNets}
\alias{exportGeneNets}
\title{Create gene interaction networks for all significant gene sets.}
\usage{
exportGeneNets(topTables, networks, collection, string, outDir,
  geneSetIDs = NULL, fields = c(geneID = "ENTREZID", symbol = "SYMBOL",
  logFC = "logFC", p = "adj.P.Val"))
}
\arguments{
\item{topTables}{A named list object containing one or more data frames. The
names should be the same as those of \code{networks} argument. Each data 
frame should contain the expression analysis data used as input for the 
corresponding network in the \code{networks} arguments. They should at 
least contain four columns listing the NCBI Entrez Gene identifier, the gene
symbol, the observed log-fold change and the (adjusted) p-value of each 
gene. See the description of the \code{fields} argument for details.}

\item{networks}{A named list object containing one or more gene set networks
as returned by the \code{\link{setRankAnalysis}} function, based on the data
in the \code{topTables} argument.}

\item{collection}{The gene set collection object used to create the gene set
networks in the \code{networks} argument.}

\item{string}{An igraph object containing a species-specific protein-protein
interaction network from which to retrieve. You can use the SetRankTools
set of scripts to generate this object for your species of interest.}

\item{outDir}{The directory where to write the output files. If this 
directory doesn't exist, it will be created.}

\item{geneSetIDs}{The list of gene set identifiers for which to create gene
interaction networks. When omitted, the union of all gene sets found in the 
\code{networks} argument will be used.}

\item{fields}{A named vector of strings specifying the column names of the
data frames in the \code{topTables} argument.}
}
\description{
Creates for every gene set present in one or more gene set networks
a gene interaction network. This network shows all known or predicted 
protein-protein interactions between all genes in the gene set. Each network
is written out to a file in GraphML format, with the extension .net.xml. 
Additionally, a file called gene_net_styles.viz.xml is created as well. This
file contains for each gene set network a Cytoscape visualisation style
which can be used to overlay the original expression data on top of the
gene set-specific interaction network for. See the vignette for more 
details.
}
\author{
Cedric Simillion
}

