% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{setRankAnalysis}
\alias{setRankAnalysis}
\title{Advanced gene set enrichment analysis.}
\usage{
setRankAnalysis(geneIDs, setCollection, use.ranks = TRUE, setPCutoff = 0.01,
  fdrCutoff = 0.05, delete = TRUE)
}
\arguments{
\item{geneIDs}{A vector containing the set of gene IDs to test for gene set 
enrichment. This is typically the list of significant genes returned by the 
analysis of an omics dataset.}

\item{setCollection}{A gene set collection object, generated with the
\code{\link{buildSetCollection}} function.}

\item{use.ranks}{Logical value indicating if the \code{geneIDs} vector is in
ranked order or not. When \code{TRUE}, a ranked analysis will be performed.}

\item{setPCutoff}{The p-value cutoff to be used to consider a gene set
significant. Recommended value: 0.01}

\item{fdrCutoff}{The cutoff to be applied on the corrected p-value after
false-positive sets have been removed.}

\item{delete}{A flag indicating if non-significant gene sets should be 
deleted, which is the behaviour that you want. It is best to ignore this
argument, it was only added for debugging purposes.}
}
\value{
An igraph object. Use the igraph \code{\link{get.data.frame}} 
function to get a data frame with all the significant gene sets.
}
\description{
Performs advanced gene set enrichment analysis on a set of genes.
}
\examples{
options(mc.cores=1)
reference = sprintf("gene_\%03d", 1:50)
geneSets = lapply(1:9, function(i) sample(reference[((i-1)*5):((i+1)*5)], 5))
annotationTable = data.frame(termID=sprintf("set_\%02d", rep(1:9, each=5)), 
        geneID=unlist(geneSets),
        termName = sprintf("dummy gene setet \%d", rep(1:9, each=5)),
        dbName = "dummyDB",
        description = "A dummy gene set DB for testing purposes")
collection = buildSetCollection(annotationTable, referenceSet=reference)
genes = reference[sample(c(TRUE, FALSE), 50, TRUE)]
network = setRankAnalysis(genes, collection, TRUE)

}
\author{
Cedric Simillion
}

