% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_gene_pair}
\alias{plot_gene_pair}
\title{Scatter plot of two gene expressions}
\usage{
plot_gene_pair(x_list, geneA, geneB, method = "loess", se_alpha = 0.1,
  do_facet_wrap = FALSE, scales = "fixed")
}
\arguments{
\item{x_list}{A named list containing one or more n by p gene expression 
profiles, one for each group or subpopulation under consideration.}

\item{geneA}{The name of the first gene to plot. Must be either a character
string matching a column name in each matrix of x_list or an integer
to index the columns.}

\item{geneB}{The name of the second gene to plot. Must be either a character
string matching a column name in each matrix of x_list or an integer
to index the columns.}

\item{method}{Charater string either "lm" or "loess" used for plotting. 
For no line, set method = NULL.}

\item{se_alpha}{Sets transparancy of confidence interval around association 
trend line. Set to 0 to remove the confidence interval.}

\item{do_facet_wrap}{If TRUE, the groups are plotted in seperate graphs.}

\item{scales}{Only used if do_facet_wrap is TRUE. See ggplot2::facet_wrap
for details.}
}
\value{
Returns the generated plot.
}
\description{
Plots the expression of two genes for visual assessment of association.
}
\examples{
\donttest{
data(reference)
rnaseq <- reference$rnaseq
genes <- colnames(rnaseq)
plot_gene_pair(rnaseq, genes[1], genes[2])
# Suppose we had multiple data frames.
control <- rnaseq[1:100, 1:10]
treatment1 <- rnaseq[101:200, 1:10]
treatment2 <- rnaseq[201:250, 1:10]
plot_gene_pair(list(ctrl = control, trt1 = treatment1, trt2 = treatment2),
               genes[1], genes[2], method = NA)
plot_gene_pair(list(ctrl = control, trt = treatment1),
               genes[1], genes[2], do_facet_wrap = TRUE, method = "lm")
}
}
