% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full.match.R
\name{full.match}
\alias{full.match}
\title{Wrapper Match Function}
\usage{
full.match(vec1, vec2)
}
\arguments{
\item{vec1}{Vector.
Must be same length as \code{vec2}}

\item{vec2}{Vector.
Must be same length as \code{vec1}}
}
\value{
Returns a vector the same length
as the input vectors of \code{TRUE} and
\code{FALSE} for each element across the vectors
}
\description{
A wrapper function that performs
the same operations as match except accounts for
\code{NA}
}
\examples{
# Vector 1
vec1 <- c(NA,NA,"cat","dog",NA,0,"porcupine")

# Vector 2
vec2 <- c(NA,"bob","alice","dog","prince",0,NA)

# Perform match
full.match(vec1, vec2)

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
