% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SemanticNetworkCleaner.R
\name{equate}
\alias{equate}
\title{Equate Group Responses}
\usage{
equate(rmatA, rmatB)
}
\arguments{
\item{rmatA}{A semnetcleaner filtered response matrix for group 1}

\item{rmatB}{A semnetcleaner filtered response matrix for group 2}
}
\value{
A list of responses matched for group 1 (rmatA) and group 2 (rmatB)
}
\description{
An automated cleaning function for matching groups' responses
}
\examples{
#finalize rmatA
finalCmat <- finalize(convmat)
#finalize rmatB
finalRmat <- finalize(rmat)

#equate rmatA and rmatB
eq1 <- equate(finalCmat,finalRmat)

#obtain respective equated response matrices
eqCmat <- eq1$rmatA
eqRmat <- eq1$rmatB
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
